/*
 * Decompiled with CFR 0.152.
 */
package org.forester.ws.wabi;

import java.io.IOException;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.util.ForesterUtil;
import org.forester.ws.wabi.TxSearch;

public final class WabiTools {
    private static String getATxName(Taxonomy tax) throws IOException {
        String name = null;
        if (!ForesterUtil.isEmpty(tax.getScientificName())) {
            name = tax.getScientificName();
        } else if (!ForesterUtil.isEmpty(tax.getCommonName())) {
            name = tax.getCommonName();
        }
        if (ForesterUtil.isEmpty(name)) {
            String id_value = null;
            if (PhylogenyMethods.isTaxonomyHasIdentifierOfGivenProvider(tax, new String[]{"uniprot", "ncbi"})) {
                id_value = tax.getIdentifier().getValue();
            }
            if (!ForesterUtil.isEmpty(id_value)) {
                name = TxSearch.getTxName(id_value);
            }
        }
        return name;
    }

    public static String[] obtainLineage(Taxonomy tax) throws IOException {
        String[] lin;
        String name = WabiTools.getATxName(tax);
        String result = null;
        if (!ForesterUtil.isEmpty(name)) {
            result = TxSearch.searchParam(name, TxSearch.TAX_NAME_CLASS.ALL, TxSearch.TAX_RANK.ALL, 2, true);
        }
        if (!ForesterUtil.isEmpty(result) && (lin = TxSearch.getLineage(result)) != null) {
            String[] lin_plus_self = new String[lin.length + 1];
            for (int i = 0; i < lin.length; ++i) {
                lin_plus_self[i] = lin[i];
            }
            lin_plus_self[lin.length] = name;
            return lin_plus_self;
        }
        return null;
    }

    public static String obtainRank(Taxonomy tax) throws IOException {
        String result = WabiTools.searchParam(tax);
        if (!ForesterUtil.isEmpty(result)) {
            return TxSearch.getTaxonomicRank(result);
        }
        return null;
    }

    private static String searchParam(Taxonomy tax) throws IOException {
        String name = WabiTools.getATxName(tax);
        String result = null;
        if (!ForesterUtil.isEmpty(name)) {
            result = TxSearch.searchParam(name, TxSearch.TAX_NAME_CLASS.ALL, TxSearch.TAX_RANK.ALL, 2, true);
        }
        return result;
    }
}

