/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.search.io;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.nbio.core.search.io.Hsp;
import org.biojava.nbio.core.sequence.template.Sequence;

public abstract class Hit
implements Iterable<Hsp> {
    private final int hitNum;
    private final String hitId;
    private final String hitDef;
    private final String hitAccession;
    private final int hitLen;
    private final List<Hsp> hsps;
    private Sequence hitSequence;

    public Hit(int hitNum, String hitId, String hitDef, String hitAccession, int hitLen, List<Hsp> hsps, Sequence hitSequence) {
        this.hitNum = hitNum;
        this.hitId = hitId;
        this.hitDef = hitDef;
        this.hitAccession = hitAccession;
        this.hitLen = hitLen;
        this.hsps = hsps;
        this.hitSequence = hitSequence;
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + this.hitLen;
        hash = 89 * hash + (this.hsps != null ? this.hsps.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Hit other = (Hit)obj;
        if (this.hitLen != other.hitLen) {
            return false;
        }
        return this.hsps == other.hsps || this.hsps != null && this.hsps.equals(other.hsps);
    }

    public int getHitNum() {
        return this.hitNum;
    }

    public String getHitId() {
        return this.hitId;
    }

    public String getHitDef() {
        return this.hitDef;
    }

    public String getHitAccession() {
        return this.hitAccession;
    }

    public int getHitLen() {
        return this.hitLen;
    }

    public Sequence getHitSequence() {
        return this.hitSequence;
    }

    @Override
    public Iterator<Hsp> iterator() {
        return new Iterator<Hsp>(){
            int current = 0;

            @Override
            public boolean hasNext() {
                return this.current < Hit.this.hsps.size();
            }

            @Override
            public Hsp next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Hit.this.hsps.get(this.current++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The remove operation is not supported by this iterator");
            }
        };
    }
}

