/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.features;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.core.sequence.features.FeatureInterface;
import org.biojava.nbio.core.sequence.features.Qualifier;
import org.biojava.nbio.core.sequence.location.template.AbstractLocation;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.core.sequence.template.Compound;

public abstract class AbstractFeature<S extends AbstractSequence<C>, C extends Compound>
implements FeatureInterface<S, C> {
    List<FeatureInterface<S, C>> childrenFeatures = new ArrayList<FeatureInterface<S, C>>();
    FeatureInterface<S, C> parentFeature;
    AbstractLocation sequenceLocation;
    String type = "";
    String source = "";
    private String description = "";
    private String shortDescription = "";
    private Object userObject = null;
    private Map<String, List<Qualifier>> Qualifiers = new HashMap<String, List<Qualifier>>();
    public static final Comparator<FeatureInterface<?, ?>> LOCATION_LENGTH = new Comparator<FeatureInterface<?, ?>>(){

        @Override
        public int compare(FeatureInterface<?, ?> e1, FeatureInterface<?, ?> e2) {
            double end2;
            double v2;
            double v1 = e1.getLocations().getStart().getPosition().intValue();
            if (v1 < (v2 = (double)e2.getLocations().getStart().getPosition().intValue())) {
                return -1;
            }
            if (v1 > v2) {
                return 1;
            }
            double end1 = e1.getLocations().getEnd().getPosition().intValue();
            if (end1 > (end2 = (double)e2.getLocations().getEnd().getPosition().intValue())) {
                return -1;
            }
            if (end1 < end2) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<FeatureInterface<?, ?>> LENGTH = new Comparator<FeatureInterface<?, ?>>(){

        @Override
        public int compare(FeatureInterface<?, ?> e1, FeatureInterface<?, ?> e2) {
            double v2;
            double v1 = Math.abs(e1.getLocations().getEnd().getPosition() - e1.getLocations().getStart().getPosition());
            if (v1 < (v2 = (double)Math.abs(e2.getLocations().getEnd().getPosition() - e2.getLocations().getStart().getPosition()))) {
                return -1;
            }
            if (v1 > v2) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<FeatureInterface<?, ?>> TYPE = new Comparator<FeatureInterface<?, ?>>(){

        @Override
        public int compare(FeatureInterface<?, ?> o1, FeatureInterface<?, ?> o2) {
            return o1.getType().compareTo(o2.getType());
        }
    };

    public AbstractFeature(String type, String source) {
        this.type = type;
        this.source = source;
    }

    @Override
    public AbstractLocation getLocations() {
        return this.sequenceLocation;
    }

    @Override
    public void setLocation(AbstractLocation loc) {
        this.sequenceLocation = loc;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public void setParentFeature(FeatureInterface<S, C> feature) {
        this.parentFeature = feature;
    }

    @Override
    public FeatureInterface<S, C> getParentFeature() {
        return this.parentFeature;
    }

    @Override
    public List<FeatureInterface<S, C>> getChildrenFeatures() {
        return this.childrenFeatures;
    }

    @Override
    public void setChildrenFeatures(List<FeatureInterface<S, C>> features) {
        this.childrenFeatures = features;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public Map<String, List<Qualifier>> getQualifiers() {
        return this.Qualifiers;
    }

    @Override
    public void setQualifiers(Map<String, List<Qualifier>> qualifiers) {
        this.Qualifiers = qualifiers;
    }

    @Override
    public void addQualifier(String key, Qualifier qualifier) {
        if (this.Qualifiers.containsKey(key)) {
            List<Qualifier> vals = this.Qualifiers.get(key);
            vals.add(qualifier);
            this.Qualifiers.put(key, vals);
        } else {
            ArrayList<Qualifier> vals = new ArrayList<Qualifier>();
            vals.add(qualifier);
            this.Qualifiers.put(key, vals);
        }
    }
}

