/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.RNASequence;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.compound.DNACompoundSet;
import org.biojava.nbio.core.sequence.compound.RNACompoundSet;
import org.biojava.nbio.core.sequence.io.DNASequenceCreator;
import org.biojava.nbio.core.sequence.io.FastaReader;
import org.biojava.nbio.core.sequence.io.FastaSequenceParser;
import org.biojava.nbio.core.sequence.io.FileProxyDNASequenceCreator;
import org.biojava.nbio.core.sequence.io.FileProxyRNASequenceCreator;
import org.biojava.nbio.core.sequence.io.GenericFastaHeaderParser;
import org.biojava.nbio.core.sequence.io.ProteinSequenceCreator;
import org.biojava.nbio.core.sequence.io.RNASequenceCreator;

public class FastaReaderHelper {
    public static Map<String, DNASequence> readFastaDNASequence(File file, boolean lazySequenceLoad) throws IOException {
        if (!lazySequenceLoad) {
            return FastaReaderHelper.readFastaDNASequence(file);
        }
        FastaReader fastaProxyReader = new FastaReader(file, new GenericFastaHeaderParser(), new FileProxyDNASequenceCreator(file, DNACompoundSet.getDNACompoundSet(), new FastaSequenceParser()));
        return fastaProxyReader.process();
    }

    public static Map<String, RNASequence> readFastaRNASequence(File file, boolean lazySequenceLoad) throws IOException {
        if (!lazySequenceLoad) {
            return FastaReaderHelper.readFastaRNASequence(file);
        }
        FastaReader fastaProxyReader = new FastaReader(file, new GenericFastaHeaderParser(), new FileProxyRNASequenceCreator(file, RNACompoundSet.getRNACompoundSet(), new FastaSequenceParser()));
        return fastaProxyReader.process();
    }

    public static Map<String, ProteinSequence> readFastaProteinSequence(File file) throws IOException {
        FileInputStream inStream = new FileInputStream(file);
        Map<String, ProteinSequence> proteinSequences = FastaReaderHelper.readFastaProteinSequence(inStream);
        inStream.close();
        return proteinSequences;
    }

    public static Map<String, ProteinSequence> readFastaProteinSequence(InputStream inStream) throws IOException {
        FastaReader fastaReader = new FastaReader(inStream, new GenericFastaHeaderParser(), new ProteinSequenceCreator(AminoAcidCompoundSet.getAminoAcidCompoundSet()));
        return fastaReader.process();
    }

    public static Map<String, DNASequence> readFastaDNASequence(InputStream inStream) throws IOException {
        FastaReader fastaReader = new FastaReader(inStream, new GenericFastaHeaderParser(), new DNASequenceCreator(DNACompoundSet.getDNACompoundSet()));
        return fastaReader.process();
    }

    public static Map<String, DNASequence> readFastaDNASequence(File file) throws IOException {
        FileInputStream inStream = new FileInputStream(file);
        Map<String, DNASequence> dnaSequences = FastaReaderHelper.readFastaDNASequence(inStream);
        inStream.close();
        return dnaSequences;
    }

    public static Map<String, RNASequence> readFastaRNASequence(InputStream inStream) throws IOException {
        FastaReader fastaReader = new FastaReader(inStream, new GenericFastaHeaderParser(), new RNASequenceCreator(RNACompoundSet.getRNACompoundSet()));
        return fastaReader.process();
    }

    public static Map<String, RNASequence> readFastaRNASequence(File file) throws IOException {
        FileInputStream inStream = new FileInputStream(file);
        Map<String, RNASequence> rnaSequences = FastaReaderHelper.readFastaRNASequence(inStream);
        inStream.close();
        return rnaSequences;
    }
}

