/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.template;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.biojava.nbio.core.sequence.compound.NucleotideCompound;
import org.biojava.nbio.core.sequence.storage.ArrayListSequenceReader;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.core.sequence.template.SequenceProxyView;
import org.biojava.nbio.core.sequence.template.SequenceView;
import org.biojava.nbio.core.sequence.views.ComplementSequenceView;
import org.biojava.nbio.core.sequence.views.ReversedSequenceView;
import org.biojava.nbio.core.sequence.views.WindowedSequence;
import org.biojava.nbio.core.util.CRC64Checksum;

public class SequenceMixin {
    public static <C extends Compound> int countCompounds(Sequence<C> sequence, C ... compounds) {
        int count = 0;
        Map<C, Integer> compositon = SequenceMixin.getComposition(sequence);
        for (C compound : compounds) {
            if (!compositon.containsKey(compound)) continue;
            count = compositon.get(compound) + count;
        }
        return count;
    }

    public static int countGC(Sequence<NucleotideCompound> sequence) {
        CompoundSet<NucleotideCompound> cs = sequence.getCompoundSet();
        NucleotideCompound G = cs.getCompoundForString("G");
        NucleotideCompound C = cs.getCompoundForString("C");
        NucleotideCompound g = cs.getCompoundForString("g");
        NucleotideCompound c = cs.getCompoundForString("c");
        return SequenceMixin.countCompounds(sequence, (Compound[])new NucleotideCompound[]{G, C, g, c});
    }

    public static int countAT(Sequence<NucleotideCompound> sequence) {
        CompoundSet<NucleotideCompound> cs = sequence.getCompoundSet();
        NucleotideCompound A = cs.getCompoundForString("A");
        NucleotideCompound T = cs.getCompoundForString("T");
        NucleotideCompound a = cs.getCompoundForString("a");
        NucleotideCompound t = cs.getCompoundForString("t");
        return SequenceMixin.countCompounds(sequence, (Compound[])new NucleotideCompound[]{A, T, a, t});
    }

    public static <C extends Compound> Map<C, Double> getDistribution(Sequence<C> sequence) {
        HashMap<Compound, Double> results = new HashMap<Compound, Double>();
        Map<C, Integer> composition = SequenceMixin.getComposition(sequence);
        double length = sequence.getLength();
        for (Map.Entry<C, Integer> entry : composition.entrySet()) {
            double dist = entry.getValue().doubleValue() / length;
            results.put((Compound)entry.getKey(), dist);
        }
        return results;
    }

    public static <C extends Compound> Map<C, Integer> getComposition(Sequence<C> sequence) {
        HashMap<Compound, Integer> results = new HashMap<Compound, Integer>();
        for (Compound currentCompound : sequence) {
            Integer currentInteger = (Integer)results.get(currentCompound);
            if (currentInteger == null) {
                currentInteger = 0;
            }
            Integer n = currentInteger;
            currentInteger = currentInteger + 1;
            results.put(currentCompound, currentInteger);
        }
        return results;
    }

    public static <C extends Compound> void write(Appendable appendable, Sequence<C> sequence) throws IOException {
        for (Compound compound : sequence) {
            appendable.append(compound.toString());
        }
    }

    public static <C extends Compound> StringBuilder toStringBuilder(Sequence<C> sequence) {
        StringBuilder sb = new StringBuilder(sequence.getLength());
        for (Compound compound : sequence) {
            sb.append(compound.toString());
        }
        return sb;
    }

    public static <C extends Compound> String toString(Sequence<C> sequence) {
        return SequenceMixin.toStringBuilder(sequence).toString();
    }

    public static <C extends Compound> List<C> toList(Sequence<C> sequence) {
        ArrayList<Compound> list = new ArrayList<Compound>(sequence.getLength());
        for (Compound compound : sequence) {
            list.add(compound);
        }
        return list;
    }

    public static <C extends Compound> int indexOf(Sequence<C> sequence, C compound) {
        int index = 1;
        for (Compound currentCompound : sequence) {
            if (currentCompound.equals(compound)) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    public static <C extends Compound> int lastIndexOf(Sequence<C> sequence, C compound) {
        int index = SequenceMixin.indexOf(new ReversedSequenceView<C>(sequence), compound);
        return sequence.getLength() - index + 1;
    }

    public static <C extends Compound> Iterator<C> createIterator(Sequence<C> sequence) {
        return new SequenceIterator<C>(sequence);
    }

    public static <C extends Compound> SequenceView<C> createSubSequence(Sequence<C> sequence, int start, int end) {
        return new SequenceProxyView<C>(sequence, start, end);
    }

    public static <C extends Compound> Sequence<C> shuffle(Sequence<C> sequence) {
        List<C> compounds = sequence.getAsList();
        Collections.shuffle(compounds);
        return new ArrayListSequenceReader<C>(compounds, sequence.getCompoundSet());
    }

    public static <C extends Compound> String checksum(Sequence<C> sequence) {
        CRC64Checksum checksum = new CRC64Checksum();
        for (Compound compound : sequence) {
            checksum.update(compound.getShortName());
        }
        return checksum.toString();
    }

    public static <C extends Compound> List<SequenceView<C>> nonOverlappingKmers(Sequence<C> sequence, int kmer) {
        ArrayList<SequenceView<C>> l = new ArrayList<SequenceView<C>>();
        WindowedSequence<C> w = new WindowedSequence<C>(sequence, kmer);
        for (SequenceView<C> view : w) {
            l.add(view);
        }
        return l;
    }

    public static <C extends Compound> List<SequenceView<C>> overlappingKmers(Sequence<C> sequence, int kmer) {
        int i;
        ArrayList<SequenceView<C>> l = new ArrayList<SequenceView<C>>();
        ArrayList<Iterator<SequenceView<C>>> windows = new ArrayList<Iterator<SequenceView<C>>>();
        for (i = 1; i <= kmer; ++i) {
            if (i == 1) {
                windows.add(new WindowedSequence<C>(sequence, kmer).iterator());
                continue;
            }
            SequenceView<C> sv = sequence.getSubSequence(i, sequence.getLength());
            windows.add(new WindowedSequence<C>(sv, kmer).iterator());
        }
        block1: while (true) {
            i = 0;
            while (true) {
                if (i >= kmer) continue block1;
                Iterator iterator = (Iterator)windows.get(i);
                boolean breakLoop = true;
                if (iterator.hasNext()) {
                    l.add((SequenceView)iterator.next());
                    breakLoop = false;
                }
                if (breakLoop) break block1;
                ++i;
            }
            break;
        }
        return l;
    }

    public static <C extends Compound> SequenceView<C> inverse(Sequence<C> sequence) {
        ReversedSequenceView<C> reverse = new ReversedSequenceView<C>(sequence);
        if (sequence.getCompoundSet().isComplementable()) {
            return new ComplementSequenceView<C>(reverse);
        }
        return reverse;
    }

    public static <C extends Compound> boolean sequenceEqualityIgnoreCase(Sequence<C> source, Sequence<C> target) {
        return SequenceMixin.baseSequenceEquality(source, target, true);
    }

    public static <C extends Compound> boolean sequenceEquality(Sequence<C> source, Sequence<C> target) {
        return SequenceMixin.baseSequenceEquality(source, target, false);
    }

    private static <C extends Compound> boolean baseSequenceEquality(Sequence<C> source, Sequence<C> target, boolean ignoreCase) {
        boolean equal = true;
        if (source.getLength() == target.getLength() && source.getCompoundSet().equals(target.getCompoundSet())) {
            Iterator sIter = source.iterator();
            Iterator tIter = target.iterator();
            while (sIter.hasNext()) {
                Compound s = (Compound)sIter.next();
                Compound t = (Compound)tIter.next();
                boolean cEqual = ignoreCase ? s.equalsIgnoreCase(t) : s.equals(t);
                if (cEqual) continue;
                equal = false;
                break;
            }
        } else {
            equal = false;
        }
        return equal;
    }

    public static class SequenceIterator<C extends Compound>
    implements Iterator<C> {
        private final Sequence<C> sequence;
        private final int length;
        private int currentPosition = 0;

        public SequenceIterator(Sequence<C> sequence) {
            this.sequence = sequence;
            this.length = sequence.getLength();
        }

        @Override
        public boolean hasNext() {
            return this.currentPosition < this.length;
        }

        @Override
        public C next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Exhausted sequence of elements");
            }
            return this.sequence.getCompoundAt(++this.currentPosition);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove() on a SequenceIterator");
        }
    }
}

