/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.transcription;

import java.util.List;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.NucleotideCompound;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.util.Equals;
import org.biojava.nbio.core.util.Hashcoder;

public interface Table {
    public List<Codon> getCodons(CompoundSet<NucleotideCompound> var1, CompoundSet<AminoAcidCompound> var2);

    public CompoundSet<Codon> getCodonCompoundSet(CompoundSet<NucleotideCompound> var1, CompoundSet<AminoAcidCompound> var2);

    public boolean isStart(AminoAcidCompound var1);

    public static class CaseInsensitiveTriplet {
        private final NucleotideCompound one;
        private final NucleotideCompound two;
        private final NucleotideCompound three;
        private transient boolean hashSet = false;
        private transient int hash;
        private transient boolean stringSet = false;
        private transient String stringify;

        public CaseInsensitiveTriplet(NucleotideCompound one, NucleotideCompound two, NucleotideCompound three) {
            this.one = one;
            this.two = two;
            this.three = three;
        }

        public NucleotideCompound getOne() {
            return this.one;
        }

        public NucleotideCompound getTwo() {
            return this.two;
        }

        public NucleotideCompound getThree() {
            return this.three;
        }

        public boolean equals(Object obj) {
            boolean equals = false;
            if (Equals.classEqual(this, obj)) {
                CaseInsensitiveTriplet casted = (CaseInsensitiveTriplet)obj;
                return this.toString().equals(casted.toString());
            }
            return equals;
        }

        public int hashCode() {
            if (!this.hashSet) {
                this.hash = this.toString().hashCode();
                this.hashSet = true;
            }
            return this.hash;
        }

        public String toString() {
            if (!this.stringSet) {
                this.stringify = this.getOne().getUpperedBase() + this.getTwo().getUpperedBase() + this.getThree().getUpperedBase();
            }
            return this.stringify;
        }

        public int intValue() {
            return 16 * this.compoundToInt(this.getOne()) + 4 * this.compoundToInt(this.getTwo()) + this.compoundToInt(this.getThree());
        }

        public int compoundToInt(NucleotideCompound c) {
            char b = c.getUpperedBase().charAt(0);
            return b;
        }
    }

    public static class Codon
    implements Compound {
        private final CaseInsensitiveTriplet triplet;
        private final boolean start;
        private final boolean stop;
        private final AminoAcidCompound aminoAcid;
        private final String stringified;

        public Codon(CaseInsensitiveTriplet triplet, AminoAcidCompound aminoAcid, boolean start, boolean stop) {
            this.triplet = triplet;
            this.start = start;
            this.stop = stop;
            this.aminoAcid = aminoAcid;
            this.stringified = triplet.toString();
        }

        public Codon(CaseInsensitiveTriplet triplet) {
            this(triplet, null, false, false);
        }

        public NucleotideCompound getOne() {
            return this.triplet.getOne();
        }

        public NucleotideCompound getTwo() {
            return this.triplet.getTwo();
        }

        public NucleotideCompound getThree() {
            return this.triplet.getThree();
        }

        public boolean isStart() {
            return this.start;
        }

        public boolean isStop() {
            return this.stop;
        }

        public AminoAcidCompound getAminoAcid() {
            return this.aminoAcid;
        }

        public CaseInsensitiveTriplet getTriplet() {
            return this.triplet;
        }

        public boolean equals(Object obj) {
            boolean equals = false;
            if (Equals.classEqual(this, obj)) {
                Codon casted = (Codon)obj;
                equals = Equals.equal(this.getTriplet(), casted.getTriplet()) && Equals.equal(this.isStart(), casted.isStart()) && Equals.equal(this.isStop(), casted.isStop()) && Equals.equal(this.getAminoAcid(), casted.getAminoAcid());
            }
            return equals;
        }

        public int hashCode() {
            int result = 9;
            result = Hashcoder.hash(result, this.getTriplet());
            result = Hashcoder.hash(result, this.isStop());
            result = Hashcoder.hash(result, this.isStart());
            result = Hashcoder.hash(result, this.getAminoAcid());
            return result;
        }

        @Override
        public String toString() {
            return this.stringified;
        }

        @Override
        public boolean equalsIgnoreCase(Compound compound) {
            return this.toString().equalsIgnoreCase(compound.toString());
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public String getLongName() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public Float getMolecularWeight() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public String getShortName() {
            return this.stringified;
        }

        @Override
        public void setDescription(String description) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void setLongName(String longName) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void setMolecularWeight(Float molecularWeight) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void setShortName(String shortName) {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

