/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.protmod;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Component {
    private final Set<String> pdbccIds;
    private final boolean isNTerminal;
    private final boolean isCTerminal;
    private static Set<Component> components = null;
    private static Map<Set<String>, Component> nonTerminalComps = null;
    private static Map<Set<String>, Component> nTerminalAminoAcids = null;
    private static Map<Set<String>, Component> cTerminalAminoAcids = null;

    private static void lazyInit() {
        if (components == null) {
            components = new HashSet<Component>();
            nonTerminalComps = new HashMap<Set<String>, Component>();
            nTerminalAminoAcids = new HashMap<Set<String>, Component>();
            cTerminalAminoAcids = new HashMap<Set<String>, Component>();
        }
    }

    private Component(Set<String> pdbccIds, boolean isNTerminal, boolean isCTerminal) {
        if (pdbccIds == null || pdbccIds.isEmpty()) {
            throw new IllegalArgumentException("pdbccId or type cannot be null.");
        }
        if (isNTerminal && isCTerminal) {
            throw new IllegalArgumentException("An amino acid can be specified atN-terminal or C-terminal but not both.");
        }
        this.pdbccIds = pdbccIds;
        this.isNTerminal = isNTerminal;
        this.isCTerminal = isCTerminal;
    }

    public Set<String> getPdbccIds() {
        return this.pdbccIds;
    }

    public boolean isNTerminal() {
        return this.isNTerminal;
    }

    public boolean isCTerminal() {
        return this.isCTerminal;
    }

    public static Component of(String pdbccId) {
        return Component.of(pdbccId, false, false);
    }

    public static Component of(String pdbccId, boolean isNTerminal, boolean isCTerminal) {
        return Component.of(Collections.singleton(pdbccId), isNTerminal, isCTerminal);
    }

    public static Component of(Set<String> pdbccIds) {
        return Component.of(pdbccIds, false, false);
    }

    public static Component of(Set<String> pdbccIds, boolean isNTerminal, boolean isCTerminal) {
        Component comp;
        if (isNTerminal && isCTerminal) {
            throw new IllegalArgumentException("An amino acid can be atN-terminal or C-terminal but not both.");
        }
        Component.lazyInit();
        if (isNTerminal) {
            comp = nTerminalAminoAcids.get(pdbccIds);
            if (comp == null) {
                comp = new Component(pdbccIds, isNTerminal, isCTerminal);
                nTerminalAminoAcids.put(pdbccIds, comp);
            }
        } else if (isCTerminal) {
            comp = cTerminalAminoAcids.get(pdbccIds);
            if (comp == null) {
                comp = new Component(pdbccIds, isNTerminal, isCTerminal);
                cTerminalAminoAcids.put(pdbccIds, comp);
            }
        } else {
            comp = nonTerminalComps.get(pdbccIds);
            if (comp == null) {
                comp = new Component(pdbccIds, isNTerminal, isCTerminal);
                nonTerminalComps.put(pdbccIds, comp);
            }
        }
        components.add(comp);
        return comp;
    }

    public static Set<Component> allComponents() {
        return Collections.unmodifiableSet(components);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPdbccIds());
        if (this.isCTerminal()) {
            sb.append("(C)");
        } else if (this.isNTerminal()) {
            sb.append("(N)");
        }
        return sb.toString();
    }
}

