/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.phylo;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.biojava.nbio.core.sequence.MultipleSequenceAlignment;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.io.FastaReader;
import org.biojava.nbio.core.sequence.io.GenericFastaHeaderParser;
import org.biojava.nbio.core.sequence.io.ProteinSequenceCreator;
import org.biojava.nbio.core.sequence.io.template.SequenceCreatorInterface;
import org.biojava.nbio.core.sequence.io.template.SequenceHeaderParserInterface;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.phylo.CheckTreeAccuracy;
import org.biojava.nbio.phylo.Comparison;
import org.biojava.nbio.phylo.NJTreeProgressListener;
import org.biojava.nbio.phylo.ProgressListenerStub;
import org.biojava.nbio.phylo.ResidueProperties;
import org.biojava.nbio.phylo.ScoreMatrix;
import org.biojava.nbio.phylo.TreeConstructionAlgorithm;
import org.biojava.nbio.phylo.TreeType;
import org.forester.evoinference.distance.NeighborJoining;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.evoinference.matrix.distance.DistanceMatrix;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeConstructor<C extends AbstractSequence<D>, D extends Compound>
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(TreeConstructor.class);
    TreeType treeType;
    TreeConstructionAlgorithm treeConstructionAlgorithm;
    NJTreeProgressListener treeProgessListener;
    MultipleSequenceAlignment<C, D> multipleSequenceAlignment = new MultipleSequenceAlignment();
    boolean verbose = false;
    Phylogeny p = null;
    BasicSymmetricalDistanceMatrix matrix = null;
    DistanceMatrix copyDistanceMatrix = null;
    Vector<NJTreeProgressListener> progessListenerVector = new Vector();

    public TreeConstructor(MultipleSequenceAlignment<C, D> multipleSequenceAlignment, TreeType _treeType, TreeConstructionAlgorithm _treeConstructionAlgorithm, NJTreeProgressListener _treeProgessListener) {
        this.treeType = _treeType;
        this.treeConstructionAlgorithm = _treeConstructionAlgorithm;
        this.treeProgessListener = _treeProgessListener;
        this.multipleSequenceAlignment = multipleSequenceAlignment;
    }

    public TreeConstructor(BasicSymmetricalDistanceMatrix _matrix, TreeType _treeType, TreeConstructionAlgorithm _treeConstructionAlgorithm, NJTreeProgressListener _treeProgessListener) {
        this.matrix = _matrix;
        this.copyDistanceMatrix = CheckTreeAccuracy.copyMatrix((DistanceMatrix)this.matrix);
        this.treeType = _treeType;
        this.treeConstructionAlgorithm = _treeConstructionAlgorithm;
        this.treeProgessListener = _treeProgessListener;
    }

    public void outputPhylipDistances(String fileName) throws Exception {
        DistanceMatrix distances = this.getDistanceMatrix();
        if (distances == null) {
            throw new Exception("distance matrix has not been calculated. Requires process() method to be called first");
        }
        FileOutputStream fo = new FileOutputStream(fileName);
        PrintStream dos = new PrintStream(fo);
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(5);
        df.setMinimumFractionDigits(5);
        for (int row = 0; row < distances.getSize(); ++row) {
            dos.print(distances.getIdentifier(row));
            for (int col = 0; col < distances.getSize(); ++col) {
                dos.print(" " + df.format(distances.getValue(col, row)));
            }
            dos.println();
        }
        dos.close();
        fo.close();
    }

    private double[][] calculateDistanceMatrix(MultipleSequenceAlignment<C, D> multipleSequenceAlignment, TreeConstructionAlgorithm tca) {
        this.updateProgress("Determing Distances", 0);
        int numberOfSequences = multipleSequenceAlignment.getSize();
        String[] sequenceString = new String[numberOfSequences];
        for (int i = 0; i < multipleSequenceAlignment.getSize(); ++i) {
            sequenceString[i] = ((AbstractSequence)multipleSequenceAlignment.getAlignedSequence(i)).getSequenceAsString();
        }
        double[][] distance = new double[numberOfSequences][numberOfSequences];
        int totalloopcount = numberOfSequences / 2 * (numberOfSequences + 1);
        if (tca == TreeConstructionAlgorithm.PID) {
            int loopcount = 0;
            for (int i = 0; i < numberOfSequences - 1; ++i) {
                this.updateProgress("Determining Distances", loopcount * 100 / totalloopcount);
                for (int j = i; j < numberOfSequences; ++j) {
                    ++loopcount;
                    if (j == i) {
                        distance[i][i] = 0.0;
                        continue;
                    }
                    distance[i][j] = 100.0f - Comparison.PID(sequenceString[i], sequenceString[j]);
                    distance[j][i] = distance[i][j];
                }
            }
        } else {
            int j;
            int i;
            ScoreMatrix pwmatrix = ResidueProperties.getScoreMatrix(this.treeConstructionAlgorithm.name());
            if (pwmatrix == null) {
                pwmatrix = ResidueProperties.getScoreMatrix(TreeConstructionAlgorithm.BLOSUM62.name());
            }
            int maxscore = 0;
            int end = sequenceString[0].length();
            int loopcount = 0;
            for (i = 0; i < numberOfSequences - 1; ++i) {
                this.updateProgress("Determining Distances", loopcount * 100 / totalloopcount);
                for (j = i; j < numberOfSequences; ++j) {
                    int score = 0;
                    ++loopcount;
                    for (int k = 0; k < end; ++k) {
                        try {
                            score += pwmatrix.getPairwiseScore(sequenceString[i].charAt(k), sequenceString[j].charAt(k));
                            continue;
                        }
                        catch (Exception ex) {
                            logger.error("err creating BLOSUM62 tree", (Throwable)ex);
                        }
                    }
                    distance[i][j] = score;
                    if (score <= maxscore) continue;
                    maxscore = score;
                }
            }
            for (i = 0; i < numberOfSequences - 1; ++i) {
                for (j = i; j < numberOfSequences; ++j) {
                    distance[i][j] = (double)maxscore - distance[i][j];
                    distance[j][i] = distance[i][j];
                }
            }
        }
        this.updateProgress("Determining Distances", 100);
        return distance;
    }

    public DistanceMatrix getDistanceMatrix() {
        return this.copyDistanceMatrix;
    }

    public void cancel() {
    }

    public void process() throws Exception {
        if (this.matrix == null) {
            double[][] distances = this.calculateDistanceMatrix(this.multipleSequenceAlignment, this.treeConstructionAlgorithm);
            this.matrix = new BasicSymmetricalDistanceMatrix(this.multipleSequenceAlignment.getSize());
            for (int i = 0; i < this.matrix.getSize(); ++i) {
                this.matrix.setIdentifier(i, ((AbstractSequence)this.multipleSequenceAlignment.getAlignedSequence(i)).getAccession().getID());
            }
            for (int col = 0; col < this.matrix.getSize(); ++col) {
                for (int row = 0; row < this.matrix.getSize(); ++row) {
                    this.matrix.setValue(col, row, distances[col][row]);
                }
            }
            this.copyDistanceMatrix = CheckTreeAccuracy.copyMatrix((DistanceMatrix)this.matrix);
        }
        ArrayList<Phylogeny> ps = new ArrayList<Phylogeny>();
        NeighborJoining nj = NeighborJoining.createInstance((boolean)this.verbose);
        ps.add(nj.execute(this.matrix));
        this.p = (Phylogeny)ps.get(0);
    }

    @Override
    public void run() {
        try {
            this.process();
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
    }

    public String getNewickString(boolean simpleNewick, boolean writeDistanceToParent) throws Exception {
        PhylogenyWriter w = new PhylogenyWriter();
        StringBuffer newickString = w.toNewHampshire(this.p, simpleNewick, writeDistanceToParent);
        return newickString.toString();
    }

    public void addProgessListener(NJTreeProgressListener treeProgessListener) {
        if (treeProgessListener != null) {
            this.progessListenerVector.add(treeProgessListener);
        }
    }

    public void removeProgessListener(NJTreeProgressListener treeProgessListener) {
        if (treeProgessListener != null) {
            this.progessListenerVector.remove(treeProgessListener);
        }
    }

    public void broadcastComplete() {
        for (NJTreeProgressListener treeProgressListener : this.progessListenerVector) {
            treeProgressListener.complete(this);
        }
    }

    public void updateProgress(String state, int percentage) {
        for (NJTreeProgressListener treeProgressListener : this.progessListenerVector) {
            treeProgressListener.progress(this, state, percentage);
        }
    }

    public void updateProgress(String state, int currentCount, int totalCount) {
        for (NJTreeProgressListener treeProgressListener : this.progessListenerVector) {
            treeProgressListener.progress(this, state, currentCount, totalCount);
        }
    }

    public static void main(String[] args) {
        try {
            InputStream inStream = TreeConstructor.class.getResourceAsStream("/PF00104_small.fasta");
            FastaReader fastaReader = new FastaReader(inStream, (SequenceHeaderParserInterface)new GenericFastaHeaderParser(), (SequenceCreatorInterface)new ProteinSequenceCreator((CompoundSet)AminoAcidCompoundSet.getAminoAcidCompoundSet()));
            LinkedHashMap proteinSequences = fastaReader.process();
            inStream.close();
            MultipleSequenceAlignment multipleSequenceAlignment = new MultipleSequenceAlignment();
            for (ProteinSequence proteinSequence : proteinSequences.values()) {
                multipleSequenceAlignment.addAlignedSequence((Sequence)proteinSequence);
            }
            long readTime = System.currentTimeMillis();
            TreeConstructor treeConstructor = new TreeConstructor(multipleSequenceAlignment, TreeType.NJ, TreeConstructionAlgorithm.PID, (NJTreeProgressListener)new ProgressListenerStub());
            treeConstructor.process();
            long treeTime = System.currentTimeMillis();
            String newick = treeConstructor.getNewickString(true, true);
            logger.info("Tree time {}", (Object)(treeTime - readTime));
            logger.info(newick);
        }
        catch (FileNotFoundException ex) {
            logger.error("Can't find file specified by args[0]", (Throwable)ex);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
    }
}

