/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.commons.io.FileUtils;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.DoubleFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.spark.function.AlignmentTools;
import org.biojava.spark.utils.BiojavaSparkUtils;
import org.rcsb.mmtf.spark.data.StructureDataRDD;
import org.rcsb.mmtf.spark.utils.SparkUtils;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;

public class ChainAligner {
    private static final String tmpDirName = "SCORES";
    private static final String defaultPath = "";

    public static void main(String[] args) throws IOException {
        JavaPairRDD<String, Atom[]> chainRDD;
        Namespace ns = ChainAligner.parseArgs(args);
        String alignMethod = ns.getString("align");
        String filePath = ns.getString("hadoop");
        int minLength = ns.getInt("minlength");
        double sample = ns.getDouble("sample");
        boolean useFiles = ns.getBoolean("files");
        List pdbIdList = ns.getList("pdbId");
        if (pdbIdList.size() > 0) {
            if (useFiles) {
                StructureDataRDD structureDataRDD = new StructureDataRDD(BiojavaSparkUtils.getFromList(ChainAligner.convertToFiles(pdbIdList)).mapToPair((PairFunction & Serializable)t -> new Tuple2(t._1, (Object)BiojavaSparkUtils.convertToStructDataInt((Structure)t._2))));
                chainRDD = BiojavaSparkUtils.getChainRDD(structureDataRDD, minLength);
            } else {
                chainRDD = BiojavaSparkUtils.getChainRDD(pdbIdList, minLength);
            }
        } else if (!filePath.equals(defaultPath)) {
            chainRDD = BiojavaSparkUtils.getChainRDD(filePath, minLength, sample);
        } else {
            System.out.println("Must specify PDB ids or an hadoop sequence file");
            return;
        }
        System.out.println("Analysisng " + chainRDD.count() + " chains");
        JavaPairRDD comparisons = SparkUtils.getHalfCartesian(chainRDD, (int)chainRDD.getNumPartitions());
        JavaRDD similarities = comparisons.map((Function & Serializable)t -> new Tuple3(((Tuple2)t._1)._1, ((Tuple2)t._2)._1, (Object)AlignmentTools.getBiojavaAlignment((Atom[])((Tuple2)t._1)._2, (Atom[])((Tuple2)t._2)._2, alignMethod)));
        JavaRDD allScores = similarities.map((Function & Serializable)t -> new Tuple6(t._1(), t._2(), (Object)((AFPChain)t._3()).getTMScore(), (Object)((AFPChain)t._3()).getTotalRmsdOpt(), (Object)((AFPChain)t._3()).getTotalLenOpt(), (Object)((AFPChain)t._3()).getAlignScore())).cache();
        if (alignMethod.equals("DUMMY")) {
            JavaDoubleRDD doubleDist = allScores.mapToDouble((DoubleFunction & Serializable)t -> (Double)t._3());
            System.out.println("Average dist: " + doubleDist.mean());
        } else {
            ChainAligner.writeData((JavaRDD<Tuple6<String, String, Double, Double, Double, Double>>)allScores);
        }
    }

    private static File[] convertToFiles(List<String> pdbIdList) {
        File[] outList = new File[pdbIdList.size()];
        for (int i = 0; i < pdbIdList.size(); ++i) {
            outList[i] = new File(pdbIdList.get(i));
        }
        return outList;
    }

    private static void writeData(JavaRDD<Tuple6<String, String, Double, Double, Double, Double>> inputScores) throws IOException {
        inputScores.map((Function & Serializable)t -> (String)t._1() + "," + (String)t._2() + "," + t._3() + "," + t._4() + "," + t._5() + "," + t._6()).saveAsTextFile(tmpDirName);
        File outFile = new File(tmpDirName);
        SparkUtils.combineDirToFile((File)outFile, (String)"ID ONE, ID TWO, TM SCORE, RMSD, LENGTH, ALIGN\n");
        FileUtils.deleteDirectory((File)outFile);
    }

    private static Namespace parseArgs(String[] args) {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"Align").defaultHelp(true).description("Calculate the alignment of multiple structures");
        parser.addArgument(new String[]{"-a", "--align"}).choices((Object[])new String[]{"jCE Circular Permutation", "jFatCat_rigid", "DUMMY"}).setDefault((Object)"jFatCat_rigid").help("Specify alignment method");
        parser.addArgument(new String[]{"-s", "--score"}).choices((Object[])new String[]{"TM", "RMSD"}).setDefault((Object)"TM").help("Specify scoring method");
        parser.addArgument(new String[]{"-u", "--files"}).type(Boolean.class).setDefault((Object)false);
        parser.addArgument(new String[]{"-k", "--numclusts"}).help("The number of clusters").setDefault((Object)2);
        parser.addArgument(new String[]{"-c", "--cluster"}).choices((Object[])new String[]{"PIC"}).setDefault((Object)"PIC").help("Specify clustering method");
        parser.addArgument(new String[]{"pdbId"}).nargs("*").help("The PDB Ids to consider");
        parser.addArgument(new String[]{"-z", "--sample"}).type(Double.class).help("The sample of the PDB to take").setDefault((Object)1.0);
        parser.addArgument(new String[]{"-l", "--minlength"}).type(Double.class).help("The minimum length of each chain").setDefault((Object)60);
        parser.addArgument(new String[]{"-t", "--threshold"}).type(Double.class).help("The threshold to define an edge").setDefault((Object)0.5);
        parser.addArgument(new String[]{"-f", "--hadoop"}).help("The hadoop file to read from").setDefault((Object)defaultPath);
        Namespace ns = null;
        try {
            ns = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            System.exit(1);
        }
        return ns;
    }
}

