/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.spark.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.DoubleFunction;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.biojava.nbio.structure.AminoAcidImpl;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomImpl;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.contact.AtomContact;
import org.biojava.nbio.structure.contact.Pair;
import org.biojava.spark.data.AtomDataRDD;
import org.biojava.spark.utils.CanonNames;
import scala.Tuple2;

public class AtomContactRDD
implements Serializable {
    private static final long serialVersionUID = -1589566070085057826L;
    private JavaRDD<AtomContact> atomContactRdd;

    public void cacheData() {
        this.atomContactRdd = this.atomContactRdd.cache();
    }

    public AtomContactRDD(JavaRDD<AtomContact> atomContactRdd) {
        this.atomContactRdd = atomContactRdd;
    }

    public JavaRDD<AtomContact> getAtomContactRDD() {
        return this.atomContactRdd;
    }

    public AtomContactRDD filterDistance(double cutoff) {
        return new AtomContactRDD((JavaRDD<AtomContact>)this.atomContactRdd.filter((Function & Serializable)t -> t.getDistance() < cutoff));
    }

    public JavaDoubleRDD getDistanceDistOfAtomInts(String atomName, String otherAtomName) {
        return this.atomContactRdd.filter((Function & Serializable)t -> CanonNames.getCanonAtomNames(t).equals(CanonNames.getCanonAtomNames(this.atomAtomContact(atomName, otherAtomName)))).mapToDouble((DoubleFunction & Serializable)t -> t.getDistance());
    }

    public Map<String, Long> getAllInterGroupContacts() {
        return this.atomContactRdd.map((Function & Serializable)atomContact -> CanonNames.getCanonGroups(atomContact)).countByValue();
    }

    public Long countInterGroupContacts(String groupNameOne, String groupNameTwo) {
        return this.atomContactRdd.filter((Function & Serializable)t -> CanonNames.getCanonGroups(t).equals(CanonNames.getCanonGroups(this.groupGroupContact(groupNameOne, groupNameTwo)))).count();
    }

    public Long countInterElementContacts(String elementOne, String elementTwo) {
        return this.atomContactRdd.filter((Function & Serializable)t -> CanonNames.getCanonElementNames(t).equals(CanonNames.getCanonElementNames(this.elementElementContact(elementOne, elementTwo)))).count();
    }

    public Long countInterAtomContacts(String atomNameOne, String atomNameTwo) {
        return this.atomContactRdd.filter((Function & Serializable)t -> CanonNames.getCanonAtomNames(t).equals(CanonNames.getCanonAtomNames(this.atomAtomContact(atomNameOne, atomNameTwo)))).count();
    }

    public Map<String, Long> getAllInterAtomNameContacts() {
        return this.atomContactRdd.map((Function & Serializable)atomContact -> CanonNames.getCanonAtomNames(atomContact)).countByValue();
    }

    public Map<String, Long> getAllInterAtomElementContacts() {
        return this.atomContactRdd.map((Function & Serializable)atomContact -> CanonNames.getCanonElementNames(atomContact)).countByValue();
    }

    public AtomContactRDD filterElementGroupContacts(String groupName, String elementName) {
        return new AtomContactRDD((JavaRDD<AtomContact>)this.getAtomContactRDD().filter((Function & Serializable)t -> this.findGroupElementContacts((AtomContact)t, groupName, elementName)));
    }

    public AtomContactRDD filterElementElementContacts(String elementNameOne, String elementNameTwo) {
        return new AtomContactRDD((JavaRDD<AtomContact>)this.getAtomContactRDD().filter((Function & Serializable)t -> this.findElementElementContacts((AtomContact)t, elementNameOne, elementNameTwo)));
    }

    public List<String> getPdbIds() {
        return this.getPairs().map((Function & Serializable)t -> ((Atom)t._1).getGroup().getChain().getStructure().getPDBCode()).collect();
    }

    public List<String> getGroupIds() {
        return this.getPairs().map((Function & Serializable)t -> ((Atom)t._1).getGroup().getPDBName()).collect();
    }

    public JavaPairRDD<Atom, Atom> getPairs() {
        return this.atomContactRdd.mapToPair((PairFunction & Serializable)t -> new Tuple2(t.getPair().getFirst(), t.getPair().getSecond()));
    }

    public AtomDataRDD getAtoms() {
        return new AtomDataRDD((JavaRDD<Atom>)this.getPairs().flatMap((FlatMapFunction & Serializable)t -> Arrays.asList((Atom)t._1, (Atom)t._2).iterator()));
    }

    private boolean findElementElementContacts(AtomContact t, String atomName1, String atomName2) {
        return ((Atom)t.getPair().getFirst()).getElement().toString().equals(atomName1) ? ((Atom)t.getPair().getSecond()).getElement().toString().equals(atomName2) : ((Atom)t.getPair().getFirst()).getElement().toString().equals(atomName2) && ((Atom)t.getPair().getSecond()).getElement().toString().equals(atomName1);
    }

    private boolean findGroupElementContacts(AtomContact t, String groupName, String atomName) {
        return ((Atom)t.getPair().getFirst()).getGroup().getPDBName().equals(groupName) ? ((Atom)t.getPair().getSecond()).getElement().toString().equals(atomName) : ((Atom)t.getPair().getSecond()).getGroup().getPDBName().equals(groupName) && ((Atom)t.getPair().getFirst()).getElement().toString().equals(atomName);
    }

    private AtomContact atomAtomContact(String atomNameOne, String atomNameTwo) {
        AtomImpl atomOne = new AtomImpl();
        atomOne.setName(atomNameOne);
        AtomImpl atomTwo = new AtomImpl();
        atomTwo.setName(atomNameTwo);
        return new AtomContact(new Pair((Object)atomOne, (Object)atomTwo), 0.0);
    }

    private AtomContact elementElementContact(String elementOne, String elementTwo) {
        AtomImpl atomOne = new AtomImpl();
        atomOne.setElement(Element.valueOfIgnoreCase((String)elementOne));
        AtomImpl atomTwo = new AtomImpl();
        atomTwo.setElement(Element.valueOfIgnoreCase((String)elementTwo));
        return new AtomContact(new Pair((Object)atomOne, (Object)atomTwo), 0.0);
    }

    private AtomContact groupGroupContact(String groupNameOne, String groupNameTwo) {
        AtomImpl atomOne = new AtomImpl();
        AminoAcidImpl groupOne = new AminoAcidImpl();
        groupOne.setPDBName(groupNameOne);
        atomOne.setGroup((Group)groupOne);
        AtomImpl atomTwo = new AtomImpl();
        AminoAcidImpl groupTwo = new AminoAcidImpl();
        groupTwo.setPDBName(groupNameTwo);
        atomTwo.setGroup((Group)groupTwo);
        return new AtomContact(new Pair((Object)atomOne, (Object)atomTwo), 0.0);
    }
}

