/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.spark.data;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.biojava.nbio.structure.Atom;
import org.biojava.spark.utils.BiojavaSparkUtils;

public class AtomDataRDD {
    private Dataset<Atom> atomDataset;
    private JavaRDD<Atom> atomRdd;

    public AtomDataRDD(JavaRDD<Atom> atomRdd) {
        this.atomRdd = atomRdd;
    }

    public AtomDataRDD(Dataset<Atom> atomDataset) {
        this.atomDataset = atomDataset;
    }

    public JavaRDD<Atom> getRdd() {
        return this.atomRdd;
    }

    public void cacheData() {
        this.atomDataset = this.atomDataset.cache();
    }

    public Map<String, Long> countByElement() {
        return this.atomRdd.map((Function & Serializable)t -> t.getElement().toString()).countByValue();
    }

    public Map<String, Long> countByAtomName() {
        return this.atomRdd.map((Function & Serializable)t -> t.getName()).countByValue();
    }

    public Map<String, Long> countByGroupAtomName() {
        return this.atomRdd.map((Function & Serializable)t -> BiojavaSparkUtils.getGroupAtomName(t)).countByValue();
    }
}

