/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.spark.function;

import java.io.Serializable;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.StructureAlignmentFactory;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.util.AFPChainScorer;

public class AlignmentTools
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static AFPChain getBiojavaAlignment(Atom[] ca1, Atom[] ca2, String alignmentMethod) {
        if (alignmentMethod.equals("DUMMY")) {
            return AlignmentTools.getDummyAlignment(ca1, ca2);
        }
        AFPChain afp = null;
        try {
            StructureAlignment algorithm = StructureAlignmentFactory.getAlgorithm((String)alignmentMethod);
            afp = algorithm.align(ca1, ca2);
            double tmScore = AFPChainScorer.getTMScore((AFPChain)afp, (Atom[])ca1, (Atom[])ca2);
            afp.setTMScore(tmScore);
        }
        catch (StructureException e) {
            e.printStackTrace();
            return null;
        }
        return afp;
    }

    private static AFPChain getDummyAlignment(Atom[] ca1, Atom[] ca2) {
        int diff = ca1.length - ca2.length;
        double doubleDiff = diff;
        AFPChain outResults = new AFPChain("DUMMY");
        outResults.setTMScore(doubleDiff);
        return outResults;
    }
}

