/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.spark.function;

import org.apache.spark.api.java.function.Function;
import org.biojava.nbio.alignment.Alignments;
import org.biojava.nbio.alignment.SimpleGapPenalty;
import org.biojava.nbio.alignment.template.GapPenalty;
import org.biojava.nbio.alignment.template.PairwiseSequenceAligner;
import org.biojava.nbio.core.alignment.matrices.SubstitutionMatrixHelper;
import org.biojava.nbio.core.alignment.template.AlignedSequence;
import org.biojava.nbio.core.alignment.template.SequencePair;
import org.biojava.nbio.core.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.template.Sequence;
import scala.Tuple2;
import scala.Tuple5;

public class PairwiseSequenceComparison
implements Function<Tuple2<Tuple2<String, String>, Tuple2<String, String>>, Tuple5<String, String, Float, Float, Float>> {
    private static final boolean debug = false;

    public Tuple5<String, String, Float, Float, Float> call(Tuple2<Tuple2<String, String>, Tuple2<String, String>> tuple) throws Exception {
        Tuple2 p1 = (Tuple2)tuple._1();
        Tuple2 p2 = (Tuple2)tuple._2();
        SubstitutionMatrix matrix = SubstitutionMatrixHelper.getBlosum65();
        SimpleGapPenalty penalty = new SimpleGapPenalty();
        penalty.setOpenPenalty(8);
        penalty.setExtensionPenalty(1);
        ProteinSequence prot1 = new ProteinSequence((String)p1._2());
        ProteinSequence prot2 = new ProteinSequence((String)p2._2());
        try {
            PairwiseSequenceAligner smithWaterman = Alignments.getPairwiseAligner((Sequence)prot1, (Sequence)prot2, (Alignments.PairwiseSequenceAlignerType)Alignments.PairwiseSequenceAlignerType.LOCAL, (GapPenalty)penalty, (SubstitutionMatrix)matrix);
            SequencePair alignment = smithWaterman.getPair();
            int numIdenticals = alignment.getNumIdenticals();
            int aligLength = alignment.getLength();
            float percentIdenticals = (float)numIdenticals / (float)aligLength;
            int l1 = prot1.getLength();
            int l2 = prot2.getLength();
            int size = alignment.getLength();
            AlignedSequence alignedSequence1 = alignment.getAlignedSequence(1);
            AlignedSequence alignedSequence2 = alignment.getAlignedSequence(2);
            String alignedSeq1 = alignedSequence1.getSequenceAsString().replaceAll("-", "");
            String alignedSeq2 = alignedSequence2.getSequenceAsString().replaceAll("-", "");
            int size1 = alignedSeq1.length();
            int size2 = alignedSeq2.length();
            float overlap1 = (float)size1 / (float)l1;
            float overlap2 = (float)size2 / (float)l2;
            return new Tuple5(p1._1(), p2._1(), (Object)Float.valueOf(overlap1), (Object)Float.valueOf(overlap2), (Object)Float.valueOf(percentIdenticals));
        }
        catch (Exception e) {
            System.err.println("Could not align " + (String)p1._1() + " vs." + (String)p2._1());
            return new Tuple5(p1._1(), p2._1(), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        }
    }
}

