/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.spark.graph;

import com.mxgraph.layout.mxCircleLayout;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.view.mxGraph;
import java.awt.Component;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jgrapht.Graph;
import org.jgrapht.ListenableGraph;
import org.jgrapht.ext.JGraphXAdapter;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.ListenableDirectedWeightedGraph;

public class ShowGraph {
    private static Graph<Integer, DefaultWeightedEdge> graph;
    private static String[] names;

    public ShowGraph(Graph<Integer, DefaultWeightedEdge> graph, String[] names) {
        ShowGraph.setGraph(graph);
        this.setNames(names);
    }

    public void showGraph(final double threshold, final boolean showEdgeLabels) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ShowGraph.createAndShowGui(threshold, showEdgeLabels);
            }
        });
    }

    private static void createAndShowGui(double threshold, boolean showEdgeLabels) {
        JFrame frame = new JFrame("NewGraph");
        frame.setDefaultCloseOperation(3);
        ListenableGraph<String, MyEdge> g = ShowGraph.buildGraph(threshold, showEdgeLabels);
        JGraphXAdapter graphAdapter = new JGraphXAdapter(g);
        mxCircleLayout layout = new mxCircleLayout((mxGraph)graphAdapter);
        layout.execute(graphAdapter.getDefaultParent());
        frame.add((Component)new mxGraphComponent((mxGraph)graphAdapter));
        frame.pack();
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
    }

    public static ListenableGraph<String, MyEdge> buildGraph(double threshold, boolean showEdgeLabels) {
        ListenableDirectedWeightedGraph g = new ListenableDirectedWeightedGraph(MyEdge.class);
        Graph<Integer, DefaultWeightedEdge> inGraph = ShowGraph.getGraph();
        Set edgeSet = inGraph.edgeSet();
        for (DefaultWeightedEdge e : edgeSet) {
            int sourceV = (Integer)inGraph.getEdgeSource((Object)e);
            String v1 = names[sourceV];
            int targetV = (Integer)inGraph.getEdgeTarget((Object)e);
            String v2 = names[targetV];
            g.addVertex((Object)v1);
            g.addVertex((Object)v2);
            double w = inGraph.getEdgeWeight((Object)e);
            if (!(w > threshold)) continue;
            MyEdge edge = (MyEdge)((Object)g.addEdge((Object)v1, (Object)v2));
            if (!showEdgeLabels) continue;
            g.setEdgeWeight((Object)edge, w);
        }
        return g;
    }

    public static Graph<Integer, DefaultWeightedEdge> getGraph() {
        return graph;
    }

    public static void setGraph(Graph<Integer, DefaultWeightedEdge> graph) {
        ShowGraph.graph = graph;
    }

    public String[] getNames() {
        return names;
    }

    public void setNames(String[] names) {
        ShowGraph.names = names;
    }

    public static class MyEdge
    extends DefaultWeightedEdge {
        private static final long serialVersionUID = -2329441316446644067L;

        public String toString() {
            return String.valueOf(this.getWeight());
        }
    }
}

