/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.spark.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.alg.PrimMinimumSpanningTree;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.jgrapht.traverse.BreadthFirstIterator;
import scala.Tuple3;

public class WeightedGraph {
    public static Graph<Integer, DefaultWeightedEdge> build(List<Tuple3<Integer, Integer, Double>> data) {
        SimpleWeightedGraph graph = new SimpleWeightedGraph(DefaultWeightedEdge.class);
        for (Tuple3<Integer, Integer, Double> t : data) {
            int i = (Integer)t._1();
            int j = (Integer)t._2();
            double score = (Double)t._3();
            graph.addVertex((Object)i);
            graph.addVertex((Object)j);
            DefaultWeightedEdge e = (DefaultWeightedEdge)graph.addEdge((Object)i, (Object)j);
            ((AbstractBaseGraph)graph).setEdgeWeight((Object)e, score);
        }
        return graph;
    }

    public static Graph<Integer, DefaultWeightedEdge> getMinimumSpanningTree(Graph<Integer, DefaultWeightedEdge> graph) {
        PrimMinimumSpanningTree tree = new PrimMinimumSpanningTree(graph);
        Set mspEdges = tree.getMinimumSpanningTreeEdgeSet();
        SimpleWeightedGraph mspGraph = new SimpleWeightedGraph(DefaultWeightedEdge.class);
        for (DefaultWeightedEdge e : mspEdges) {
            int sourceV = (Integer)graph.getEdgeSource((Object)e);
            int targetV = (Integer)graph.getEdgeTarget((Object)e);
            mspGraph.addVertex((Object)sourceV);
            mspGraph.addVertex((Object)targetV);
            DefaultWeightedEdge edge = (DefaultWeightedEdge)graph.getEdge((Object)sourceV, (Object)targetV);
            double w = graph.getEdgeWeight((Object)edge);
            mspGraph.addEdge((Object)sourceV, (Object)targetV, (Object)edge);
            ((AbstractBaseGraph)mspGraph).setEdgeWeight((Object)edge, w);
        }
        return mspGraph;
    }

    public static List<List<Integer>> traverse(Graph<Integer, DefaultWeightedEdge> graph) {
        int target;
        int source;
        Set vSet = graph.vertexSet();
        ArrayList verteces = new ArrayList();
        verteces.addAll(vSet);
        ArrayList<List<Integer>> segments = new ArrayList<List<Integer>>();
        BreadthFirstIterator iteratorBack = new BreadthFirstIterator(graph, verteces.get(0));
        int endVertex = 0;
        while (iteratorBack.hasNext()) {
            endVertex = (Integer)iteratorBack.next();
        }
        BreadthFirstIterator iteratorForth = new BreadthFirstIterator(graph, (Object)endVertex);
        int startVertex = 0;
        while (iteratorForth.hasNext()) {
            startVertex = (Integer)iteratorForth.next();
        }
        DijkstraShortestPath pathFinder = new DijkstraShortestPath(graph, (Object)startVertex, (Object)endVertex);
        List path = pathFinder.getPathEdgeList();
        ArrayList<Integer> segment = new ArrayList<Integer>();
        int source1 = (Integer)graph.getEdgeSource(path.get(0));
        int target1 = (Integer)graph.getEdgeTarget(path.get(0));
        int source2 = (Integer)graph.getEdgeSource(path.get(1));
        int target2 = (Integer)graph.getEdgeTarget(path.get(1));
        if (target1 == source2 || target1 == target2) {
            source = source1;
            target = target1;
        } else {
            target = source1;
            source = target1;
        }
        segment.add(source);
        segment.add(target);
        verteces.remove(verteces.indexOf(source));
        verteces.remove(verteces.indexOf(target));
        for (int p = 1; p < path.size(); ++p) {
            int sourceVnext = (Integer)graph.getEdgeSource(path.get(p));
            int targetVnext = (Integer)graph.getEdgeTarget(path.get(p));
            if (sourceVnext != target) {
                target = sourceVnext;
                source = targetVnext;
            } else {
                target = targetVnext;
                source = sourceVnext;
            }
            segment.add(target);
            verteces.remove(verteces.indexOf(target));
        }
        segments.add(segment);
        ArrayList<Integer> leafs = new ArrayList<Integer>();
        for (Integer l : verteces) {
            Set egs = graph.edgesOf((Object)l);
            if (egs.size() != 1) continue;
            leafs.add(l);
        }
        Iterator iterator = leafs.iterator();
        while (iterator.hasNext()) {
            int leaf = (Integer)iterator.next();
            int min = Integer.MAX_VALUE;
            int anchor = -1;
            for (List list : segments) {
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    int t = (Integer)iterator2.next();
                    DijkstraShortestPath pathFinderBranch = new DijkstraShortestPath(graph, (Object)leaf, (Object)t);
                    List pathBranch = pathFinderBranch.getPathEdgeList();
                    if (pathBranch.size() >= min) continue;
                    min = pathBranch.size();
                    anchor = t;
                }
            }
            if (anchor == -1) continue;
            ArrayList<Integer> branch = new ArrayList<Integer>();
            DijkstraShortestPath dijkstraShortestPath = new DijkstraShortestPath(graph, (Object)anchor, (Object)leaf);
            List b = dijkstraShortestPath.getPathEdgeList();
            if (b.size() == 1) {
                branch.add(anchor);
                branch.add(leaf);
            } else {
                branch.add(anchor);
                int start = (Integer)graph.getEdgeSource(b.get(0));
                int end = (Integer)graph.getEdgeTarget(b.get(0));
                if (anchor == start) {
                    branch.add(end);
                } else {
                    branch.add(start);
                    end = start;
                }
                for (int q = 1; q < b.size(); ++q) {
                    int s = (Integer)graph.getEdgeSource(b.get(q));
                    int e = (Integer)graph.getEdgeTarget(b.get(q));
                    if (s == end) {
                        branch.add(e);
                        end = e;
                        continue;
                    }
                    branch.add(s);
                    end = s;
                }
            }
            segments.add(branch);
        }
        return segments;
    }
}

