/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.spark.mappers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.contact.AtomContact;
import org.biojava.nbio.structure.contact.AtomContactSet;
import org.biojava.spark.utils.BiojavaSparkUtils;
import org.rcsb.mmtf.api.StructureDataInterface;
import org.rcsb.mmtf.spark.data.AtomSelectObject;
import scala.Tuple2;

public class CalculateContacts
implements FlatMapFunction<Tuple2<String, StructureDataInterface>, AtomContact> {
    private double cutoff;
    private AtomSelectObject selectObjectOne;
    private AtomSelectObject selectObjectTwo;
    private boolean fast = true;
    private static final long serialVersionUID = 7102351722106317536L;

    public CalculateContacts(AtomSelectObject selectObjectOne, AtomSelectObject selectObjectTwo, double cutoff) {
        this.cutoff = cutoff;
        this.selectObjectOne = selectObjectOne;
        this.selectObjectTwo = selectObjectTwo;
    }

    public CalculateContacts(AtomSelectObject selectObjectOne, AtomSelectObject selectObjectTwo, double cutoff, boolean fast) {
        this.cutoff = cutoff;
        this.selectObjectOne = selectObjectOne;
        this.selectObjectTwo = selectObjectTwo;
        this.fast = fast;
    }

    public Iterator<AtomContact> call(Tuple2<String, StructureDataInterface> t) throws Exception {
        String pdbId = (String)t._1;
        StructureDataInterface structure = (StructureDataInterface)t._2;
        return this.getDist(structure, pdbId, this.cutoff).iterator();
    }

    private List<AtomContact> getDist(StructureDataInterface structure, String pdbCode, double cutoff) {
        List<Atom> atomListOne;
        ArrayList<AtomContact> outList = new ArrayList<AtomContact>();
        List<Atom> atomListTwo = BiojavaSparkUtils.getAtoms(structure, this.selectObjectOne);
        if (atomListTwo.size() > 0 && (atomListOne = BiojavaSparkUtils.getAtoms(structure, this.selectObjectTwo)).size() > 0) {
            AtomContactSet atomContactSet = this.fast ? BiojavaSparkUtils.getAtomContacts(atomListOne, atomListTwo, cutoff) : BiojavaSparkUtils.getAtomContactsSlow(atomListOne, atomListTwo, cutoff);
            for (AtomContact atomContact : atomContactSet) {
                Atom atomOne = (Atom)atomContact.getPair().getFirst();
                Atom atomTwo = (Atom)atomContact.getPair().getSecond();
                if (atomOne.getGroup().getResidueNumber().equals((Object)atomTwo.getGroup().getResidueNumber())) continue;
                outList.add(atomContact);
            }
        }
        return outList;
    }
}

