/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.spark.mappers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.PairFunction;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIO;
import org.biojava.nbio.structure.StructureImpl;
import org.biojava.nbio.structure.io.mmtf.MmtfStructureReader;
import org.biojava.nbio.structure.io.mmtf.MmtfStructureWriter;
import org.biojava.nbio.structure.io.mmtf.MmtfUtils;
import org.biojava.spark.mappers.StringByteToTextByteWriter;
import org.rcsb.mmtf.api.StructureAdapterInterface;
import org.rcsb.mmtf.api.StructureDataInterface;
import org.rcsb.mmtf.dataholders.MmtfStructure;
import org.rcsb.mmtf.decoder.GenericDecoder;
import org.rcsb.mmtf.decoder.StructureDataToAdapter;
import org.rcsb.mmtf.encoder.AdapterToStructureData;
import org.rcsb.mmtf.encoder.GenericEncoder;
import org.rcsb.mmtf.encoder.WriterUtils;
import org.rcsb.mmtf.serialization.MessagePackSerialization;
import org.rcsb.mmtf.spark.utils.SparkUtils;
import scala.Tuple2;

public class MapperUtils
implements Serializable {
    private static final long serialVersionUID = -4717807367698811030L;

    public static Structure byteArrToBiojavaStruct(String pdbCodePlus, byte[] inputByteArr) throws IOException {
        Structure newStruct;
        try {
            newStruct = MapperUtils.getFomByteArray(inputByteArr);
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println(pdbCodePlus);
            StructureImpl newStruct2 = new StructureImpl();
            return newStruct2;
        }
        return newStruct;
    }

    public static JavaPairRDD<Text, BytesWritable> generateRdd(List<String> inputList, String ccdUrl) {
        MmtfUtils.setUpBioJava((String)ccdUrl);
        return SparkUtils.getSparkContext().parallelize(inputList).mapToPair((PairFunction & Serializable)t -> MapperUtils.getByteArray(t)).mapToPair((PairFunction & Serializable)t -> new Tuple2(t._1, (Object)WriterUtils.gzipCompress((byte[])((byte[])t._2)))).mapToPair((PairFunction)new StringByteToTextByteWriter());
    }

    public static Tuple2<String, byte[]> getByteArray(String pdbId) throws IOException, StructureException {
        Structure structure = StructureIO.getStructure((String)pdbId);
        byte[] outByteArr = MapperUtils.produceByteArray(structure, "Biojava-spark default");
        return new Tuple2((Object)structure.getPDBCode(), (Object)outByteArr);
    }

    public static Tuple2<String, byte[]> getByteArray(String pdbId, String producer) throws IOException, StructureException {
        Structure structure = StructureIO.getStructure((String)pdbId);
        byte[] outByteArr = MapperUtils.produceByteArray(structure, producer);
        return new Tuple2((Object)structure.getPDBCode(), (Object)outByteArr);
    }

    private static byte[] produceByteArray(Structure structure, String mmtfProducer) {
        MmtfStructure mmtfStructure = MapperUtils.encodeStructure(structure);
        mmtfStructure.setMmtfProducer(mmtfProducer);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        new MessagePackSerialization().serialize(mmtfStructure, (OutputStream)bos);
        return bos.toByteArray();
    }

    private static MmtfStructure encodeStructure(Structure structure) {
        AdapterToStructureData inflatorToGet = new AdapterToStructureData();
        new MmtfStructureWriter(structure, (StructureAdapterInterface)inflatorToGet);
        MmtfStructure mmtfStructure = new GenericEncoder((StructureDataInterface)inflatorToGet).getMmtfEncodedStructure();
        return mmtfStructure;
    }

    private static Structure getFomByteArray(byte[] inputByteArr) {
        MmtfStructureReader mmtfStructureReader = new MmtfStructureReader();
        new StructureDataToAdapter((StructureDataInterface)new GenericDecoder(new MessagePackSerialization().deserialize((InputStream)new ByteArrayInputStream(inputByteArr))), (StructureAdapterInterface)mmtfStructureReader);
        return mmtfStructureReader.getStructure();
    }
}

