/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.spark.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.biojava.nbio.alignment.Alignments;
import org.biojava.nbio.alignment.SimpleGapPenalty;
import org.biojava.nbio.alignment.template.GapPenalty;
import org.biojava.nbio.alignment.template.PairwiseSequenceAligner;
import org.biojava.nbio.core.alignment.matrices.SubstitutionMatrixHelper;
import org.biojava.nbio.core.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.structure.AminoAcidImpl;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomImpl;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ChainImpl;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureIO;
import org.biojava.nbio.structure.contact.AtomContact;
import org.biojava.nbio.structure.contact.AtomContactSet;
import org.biojava.nbio.structure.contact.Grid;
import org.biojava.nbio.structure.contact.Pair;
import org.biojava.nbio.structure.io.mmcif.MMcifConsumer;
import org.biojava.nbio.structure.io.mmcif.SimpleMMcifConsumer;
import org.biojava.nbio.structure.io.mmcif.SimpleMMcifParser;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.biojava.nbio.structure.io.mmtf.MmtfStructureReader;
import org.biojava.nbio.structure.io.mmtf.MmtfStructureWriter;
import org.biojava.nbio.structure.io.mmtf.MmtfUtils;
import org.biojava.spark.data.AtomContactRDD;
import org.biojava.spark.data.AtomDataRDD;
import org.biojava.spark.mappers.CalculateContacts;
import org.biojava.spark.mappers.CalculateFrequency;
import org.biojava.spark.mappers.PdbIdToMmtf;
import org.biojava.spark.mappers.StringByteToTextByteWriter;
import org.rcsb.mmtf.api.StructureAdapterInterface;
import org.rcsb.mmtf.api.StructureDataInterface;
import org.rcsb.mmtf.dataholders.MmtfStructure;
import org.rcsb.mmtf.decoder.GenericDecoder;
import org.rcsb.mmtf.decoder.ReaderUtils;
import org.rcsb.mmtf.decoder.StructureDataToAdapter;
import org.rcsb.mmtf.encoder.AdapterToStructureData;
import org.rcsb.mmtf.encoder.WriterUtils;
import org.rcsb.mmtf.serialization.MessagePackSerialization;
import org.rcsb.mmtf.spark.data.AtomSelectObject;
import org.rcsb.mmtf.spark.data.Segment;
import org.rcsb.mmtf.spark.data.SegmentDataRDD;
import org.rcsb.mmtf.spark.data.StructureDataRDD;
import org.rcsb.mmtf.spark.utils.SparkUtils;
import scala.Tuple2;

public class BiojavaSparkUtils {
    private static final String CA_NAME = "CA";
    private static final String CHAIN_NAME = "A";

    public static Atom[] getCaAtoms(Segment segment) {
        Point3d[] points = segment.getCoordinates();
        ChainImpl chain = new ChainImpl();
        chain.setId(CHAIN_NAME);
        chain.setName(CHAIN_NAME);
        Atom[] atoms = new Atom[points.length];
        int j = 0;
        for (int i = 0; i < points.length; ++i) {
            if (points[i] == null) continue;
            atoms[j] = new AtomImpl();
            atoms[j].setName(CA_NAME);
            AminoAcidImpl group = new AminoAcidImpl();
            group.setPDBName("GLU");
            group.addAtom(atoms[j]);
            group.setChain((Chain)chain);
            group.setResidueNumber(new ResidueNumber(CHAIN_NAME, Integer.valueOf(j), Character.valueOf('\u0000')));
            atoms[j].setX(points[i].x);
            atoms[j].setY(points[i].y);
            atoms[j].setZ(points[i].z);
            ++j;
        }
        return atoms;
    }

    public static AtomContactRDD findContacts(StructureDataRDD structureDataRDD, AtomSelectObject selectObjectOne, AtomSelectObject selectObjectTwo, double cutoff) {
        return new AtomContactRDD((JavaRDD<AtomContact>)structureDataRDD.getJavaRdd().flatMap((FlatMapFunction)new CalculateContacts(selectObjectOne, selectObjectTwo, cutoff)));
    }

    public static AtomContactRDD findContacts(StructureDataRDD structureDataRDD, AtomSelectObject selectObjectOne, double cutoff) {
        return new AtomContactRDD((JavaRDD<AtomContact>)structureDataRDD.getJavaRdd().flatMap((FlatMapFunction)new CalculateContacts(selectObjectOne, selectObjectOne, cutoff, false)));
    }

    public static AtomContactRDD findContacts(StructureDataRDD structureDataRDD, double cutoff) {
        return new AtomContactRDD((JavaRDD<AtomContact>)structureDataRDD.getJavaRdd().flatMap((FlatMapFunction)new CalculateContacts(new AtomSelectObject(), new AtomSelectObject(), cutoff)));
    }

    public static AtomDataRDD findAtoms(StructureDataRDD structureDataRDD, AtomSelectObject selectObjectOne) {
        return new AtomDataRDD((JavaRDD<Atom>)structureDataRDD.getJavaRdd().flatMap((FlatMapFunction)new CalculateFrequency(selectObjectOne)));
    }

    public static AtomDataRDD findAtoms(StructureDataRDD structureDataRDD) {
        return new AtomDataRDD((JavaRDD<Atom>)structureDataRDD.getJavaRdd().flatMap((FlatMapFunction)new CalculateFrequency(new AtomSelectObject())));
    }

    public static JavaPairRDD<String, Structure> getBiojavaRdd(String filePath) {
        return SparkUtils.getSparkContext().sequenceFile(filePath, Text.class, BytesWritable.class, 8).mapToPair((PairFunction & Serializable)t -> new Tuple2((Object)((Text)t._1).toString(), (Object)ReaderUtils.deflateGzip((byte[])((BytesWritable)t._2).getBytes()))).mapToPair((PairFunction & Serializable)t -> new Tuple2(t._1, (Object)new MessagePackSerialization().deserialize((InputStream)new ByteArrayInputStream((byte[])t._2)))).mapToPair((PairFunction & Serializable)t -> new Tuple2(t._1, (Object)new GenericDecoder((MmtfStructure)t._2))).mapToPair((PairFunction & Serializable)t -> {
            MmtfStructureReader mmtfStructureReader = new MmtfStructureReader();
            new StructureDataToAdapter((StructureDataInterface)t._2, (StructureAdapterInterface)mmtfStructureReader);
            return new Tuple2(t._1, (Object)mmtfStructureReader.getStructure());
        });
    }

    public static List<Atom> getAtoms(StructureDataInterface structure, AtomSelectObject atomSelectObject) {
        List<Atom> atomList = BiojavaSparkUtils.getAtoms(structure);
        Stream<Object> atomStream = atomList.stream();
        List atomNames = atomSelectObject.getAtomNameList();
        List elementNames = atomSelectObject.getElementNameList();
        List groupNames = atomSelectObject.getGroupNameList();
        boolean charged = atomSelectObject.isCharged();
        String groupType = atomSelectObject.getGroupType();
        if (atomNames != null && atomNames.size() != 0) {
            atomStream = atomStream.filter(atom -> atomNames.contains(atom.getName()));
        }
        if (elementNames != null && elementNames.size() != 0) {
            atomStream = atomStream.filter(atom -> elementNames.contains(atom.getElement().toString()));
        }
        if (groupNames != null && groupNames.size() != 0) {
            atomStream = atomStream.filter(atom -> groupNames.contains(atom.getGroup().getPDBName()));
        }
        if (charged) {
            atomStream = atomStream.filter(atom -> atom.getCharge() != 0);
        }
        if (groupType != null) {
            atomStream = atomStream.filter(atom -> atom.getGroup().getChemComp().getType().equals(groupType));
        }
        return atomStream.collect(Collectors.toList());
    }

    public static AtomContactSet getAtomContacts(List<Atom> atoms, double cutoff) {
        Grid grid = new Grid(cutoff);
        Atom[] atomArray = atoms.toArray(new Atom[atoms.size()]);
        grid.addAtoms(atomArray);
        return grid.getContacts();
    }

    public static AtomContactSet getAtomContacts(List<Atom> atomListOne, List<Atom> atomListTwo, double cutoff) {
        Grid grid = new Grid(cutoff);
        Atom[] atomArrayOne = atomListOne.toArray(new Atom[atomListOne.size()]);
        Atom[] atomArrayTwo = atomListTwo.toArray(new Atom[atomListTwo.size()]);
        grid.addAtoms(atomArrayOne, atomArrayTwo);
        return grid.getContacts();
    }

    public static AtomContactSet getAtomContactsSlow(List<Atom> atomListOne, List<Atom> atomListTwo, double cutoff) {
        AtomContactSet atomContactSet = new AtomContactSet(cutoff);
        for (int i = 0; i < atomListOne.size(); ++i) {
            for (int j = i; j < atomListTwo.size(); ++j) {
                double distance;
                Atom atomTwo;
                Atom atomOne = atomListOne.get(i);
                if (atomOne.equals(atomTwo = atomListTwo.get(j)) || !((distance = Calc.getDistance((Atom)atomOne, (Atom)atomTwo)) < cutoff)) continue;
                AtomContact atomContact = new AtomContact(new Pair((Object)atomOne, (Object)atomTwo), distance);
                atomContactSet.add(atomContact);
            }
        }
        return atomContactSet;
    }

    public static JavaPairRDD<String, Atom[]> getChainRDD(List<String> pdbIdList, int minLength) throws IOException {
        return BiojavaSparkUtils.getChainRDD(new StructureDataRDD(pdbIdList), minLength);
    }

    public static JavaPairRDD<String, Atom[]> getChainRDD(String filePath, int minLength, double sample) throws IOException {
        return BiojavaSparkUtils.getChainRDD(new StructureDataRDD(filePath).sample(sample), minLength);
    }

    public static JavaPairRDD<String, Atom[]> getChainRDD(List<String> pdbIdList) throws IOException {
        return BiojavaSparkUtils.getChainRDD(pdbIdList, 60);
    }

    public static JavaPairRDD<String, Atom[]> getChainRDD(StructureDataRDD structureDataRDD, int minLength) throws IOException {
        return structureDataRDD.getCalpha().filterMinLength(minLength).getSegmentRDD().mapToPair((PairFunction & Serializable)t -> new Tuple2(t._1, (Object)BiojavaSparkUtils.getCaAtoms((Segment)t._2))).cache();
    }

    public static List<Atom> getAtoms(StructureDataInterface structure) {
        ArrayList<Atom> atomList = new ArrayList<Atom>();
        int lastNumGroup = 0;
        int atomCounter = 0;
        for (int chainInd = 0; chainInd < structure.getChainsPerModel()[0]; ++chainInd) {
            ChemComp cc = new ChemComp();
            cc.setType(BiojavaSparkUtils.getTypeFromChainId(structure, chainInd));
            int numGroups = structure.getGroupsPerChain()[chainInd];
            ChainImpl chain = new ChainImpl();
            chain.setId(structure.getChainIds()[chainInd]);
            for (int i = 0; i < numGroups; ++i) {
                AminoAcidImpl group = new AminoAcidImpl();
                group.setChemComp(cc);
                group.setResidueNumber(structure.getChainIds()[chainInd], Integer.valueOf(i), Character.valueOf('?'));
                group.setChain((Chain)chain);
                int groupType = structure.getGroupTypeIndices()[i + lastNumGroup];
                group.setPDBName(structure.getGroupName(groupType));
                int[] atomCharges = structure.getGroupAtomCharges(groupType);
                for (int j = 0; j < atomCharges.length; ++j) {
                    AtomImpl atom = new AtomImpl();
                    atom.setX((double)structure.getxCoords()[atomCounter]);
                    atom.setY((double)structure.getyCoords()[atomCounter]);
                    atom.setZ((double)structure.getzCoords()[atomCounter]);
                    atom.setName(structure.getGroupAtomNames(groupType)[j]);
                    atom.setElement(Element.valueOfIgnoreCase((String)structure.getGroupElementNames(groupType)[j]));
                    atom.setCharge((short)atomCharges[j]);
                    atom.setPDBserial(structure.getAtomIds()[atomCounter]);
                    atom.setGroup((Group)group);
                    atomList.add((Atom)atom);
                    ++atomCounter;
                }
            }
            lastNumGroup += structure.getGroupsPerChain()[chainInd];
        }
        return atomList;
    }

    public static SegmentDataRDD filterSequenceSimilar(SegmentDataRDD segmentDataRDD, String inputSequence, double minSimilarity) throws CompoundNotFoundException {
        ProteinSequence proteinSequence = new ProteinSequence(inputSequence);
        int gop = 8;
        int extend = 1;
        SimpleGapPenalty penalty = new SimpleGapPenalty();
        penalty.setOpenPenalty(gop);
        penalty.setExtensionPenalty(extend);
        SubstitutionMatrix matrix = SubstitutionMatrixHelper.getBlosum65();
        return new SegmentDataRDD(segmentDataRDD.getSegmentRDD().filter(arg_0 -> BiojavaSparkUtils.lambda$filterSequenceSimilar$8cdf0a26$1(proteinSequence, (GapPenalty)penalty, matrix, minSimilarity, arg_0)));
    }

    public static String getGroupAtomName(Atom atom) {
        return atom.getGroup().getPDBName() + "_" + atom.getName();
    }

    public static StructureDataRDD getStructureRDDFromMmcif(String filePath) {
        return new StructureDataRDD(SparkUtils.getSparkContext().sequenceFile(filePath, Text.class, BytesWritable.class, 8).mapToPair((PairFunction & Serializable)t -> new Tuple2((Object)((Text)t._1).toString(), (Object)ReaderUtils.deflateGzip((byte[])((BytesWritable)t._2).getBytes()))).mapToPair((PairFunction & Serializable)t -> new Tuple2(t._1, (Object)BiojavaSparkUtils.getStructureFromMmmCifText((byte[])t._2))).mapToPair((PairFunction & Serializable)t -> new Tuple2(t._1, (Object)BiojavaSparkUtils.convertToStructDataInt((Structure)t._2))));
    }

    public static StructureDataInterface convertToStructDataInt(Structure structure) {
        AdapterToStructureData writerToEncoder = new AdapterToStructureData();
        new MmtfStructureWriter(structure, (StructureAdapterInterface)writerToEncoder);
        return writerToEncoder;
    }

    private static Structure getStructureFromMmmCifText(byte[] inputText) throws IOException {
        SimpleMMcifConsumer simpleMMcifConsumer = new SimpleMMcifConsumer();
        SimpleMMcifParser simpleMMcifParser = new SimpleMMcifParser();
        simpleMMcifParser.addMMcifConsumer((MMcifConsumer)simpleMMcifConsumer);
        simpleMMcifParser.parse((InputStream)new ByteArrayInputStream(inputText));
        return simpleMMcifConsumer.getStructure();
    }

    public static JavaPairRDD<String, Structure> getFromList(File[] pdbIdList) {
        return SparkUtils.getSparkContext().parallelize(Arrays.asList(pdbIdList)).mapToPair((PairFunction & Serializable)file -> new Tuple2((Object)file.getName(), (Object)StructureIO.getStructure((String)file.getAbsolutePath())));
    }

    public static String getTypeFromChainId(StructureDataInterface structureDataInterface, int chainInd) {
        for (int i = 0; i < structureDataInterface.getNumEntities(); ++i) {
            for (int chainIndex : structureDataInterface.getEntityChainIndexList(i)) {
                if (chainInd != chainIndex) continue;
                return structureDataInterface.getEntityType(i);
            }
        }
        System.err.println("ERROR FINDING ENTITY FOR CHAIN: " + chainInd);
        return "NULL";
    }

    public static void writeToFile(List<String> pdbCodeList, String uri, String producer) {
        JavaSparkContext javaSparkContext = SparkUtils.getSparkContext();
        MmtfUtils.setUpBioJava();
        JavaPairRDD distData = javaSparkContext.parallelize(pdbCodeList).mapToPair((PairFunction)new PdbIdToMmtf(producer)).mapToPair((PairFunction & Serializable)t -> new Tuple2(t._1, (Object)WriterUtils.gzipCompress((byte[])((byte[])t._2)))).mapToPair((PairFunction)new StringByteToTextByteWriter());
        distData.saveAsHadoopFile(uri, Text.class, BytesWritable.class, SequenceFileOutputFormat.class);
        javaSparkContext.close();
    }

    private static /* synthetic */ Boolean lambda$filterSequenceSimilar$8cdf0a26$1(ProteinSequence proteinSequence, GapPenalty penalty, SubstitutionMatrix matrix, double minSimilarity, Tuple2 t) throws Exception {
        ProteinSequence otherSequence = new ProteinSequence(((Segment)t._2).getSequence());
        PairwiseSequenceAligner smithWaterman = Alignments.getPairwiseAligner((Sequence)proteinSequence, (Sequence)otherSequence, (Alignments.PairwiseSequenceAlignerType)Alignments.PairwiseSequenceAlignerType.LOCAL, (GapPenalty)penalty, (SubstitutionMatrix)matrix);
        if (smithWaterman.getSimilarity() < minSimilarity) {
            return false;
        }
        return true;
    }
}

