/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.spark.utils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.contact.AtomContact;

public class CanonNames {
    private static final String JOINER = "_";

    public static String getCanonGroups(AtomContact atomContact) {
        return CanonNames.getCanonStrings(((Atom)atomContact.getPair().getFirst()).getGroup().getPDBName(), ((Atom)atomContact.getPair().getSecond()).getGroup().getPDBName());
    }

    public static String getCanonAtomNames(AtomContact atomContact) {
        ArrayList<String> groupList = new ArrayList<String>();
        groupList.add(((Atom)atomContact.getPair().getFirst()).getName());
        groupList.add(((Atom)atomContact.getPair().getSecond()).getName());
        return CanonNames.getCanonStrings(((Atom)atomContact.getPair().getFirst()).getName(), ((Atom)atomContact.getPair().getSecond()).getName());
    }

    public static String getCanonElementNames(AtomContact atomContact) {
        return CanonNames.getCanonStrings(((Atom)atomContact.getPair().getFirst()).getElement().toString(), ((Atom)atomContact.getPair().getSecond()).getElement().toString());
    }

    public static String getCanonChains(AtomContact atomContact) {
        return CanonNames.getCanonStrings(((Atom)atomContact.getPair().getFirst()).getGroup().getChainId(), ((Atom)atomContact.getPair().getSecond()).getGroup().getChainId());
    }

    public static String getCanonResidueNumbers(AtomContact atomContact) {
        return CanonNames.getCanonStrings(((Atom)atomContact.getPair().getFirst()).getGroup().getResidueNumber().getSeqNum().toString(), ((Atom)atomContact.getPair().getSecond()).getGroup().getResidueNumber().getSeqNum().toString());
    }

    private static String getCanonStrings(String stringOne, String stringTwo) {
        ArrayList<String> groupList = new ArrayList<String>();
        groupList.add(stringOne);
        groupList.add(stringTwo);
        return groupList.stream().sorted().collect(Collectors.joining(JOINER));
    }
}

