/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.util.HashMap;
import java.util.Set;

public enum ExperimentalTechnique {
    XRAY_DIFFRACTION("X-RAY DIFFRACTION", true, false),
    SOLUTION_NMR("SOLUTION NMR", false, true),
    SOLID_STATE_NMR("SOLID-STATE NMR", false, true),
    ELECTRON_MICROSCOPY("ELECTRON MICROSCOPY", false, false),
    ELECTRON_CRYSTALLOGRAPHY("ELECTRON CRYSTALLOGRAPHY", true, false),
    FIBER_DIFFRACTION("FIBER DIFFRACTION", false, false),
    NEUTRON_DIFFRACTION("NEUTRON DIFFRACTION", true, false),
    SOLUTION_SCATTERING("SOLUTION SCATTERING", false, false),
    POWDER_DIFFRACTION("POWDER DIFFRACTION", true, false),
    FLUORESCENCE_TRANSFER("FLUORESCENCE TRANSFER", false, false),
    INFRARED_SPECTROSCOPY("INFRARED SPECTROSCOPY", false, false);

    private static final HashMap<String, ExperimentalTechnique> expTechStr2Value;
    private String name;
    private boolean isCrystallographic;
    private boolean isNmr;

    private ExperimentalTechnique(String name, boolean isXtallographic, boolean isNmr) {
        this.name = name;
        this.isCrystallographic = isXtallographic;
        this.isNmr = isNmr;
    }

    private static HashMap<String, ExperimentalTechnique> initExpTechStr2Value() {
        HashMap<String, ExperimentalTechnique> expTechStr2Value = new HashMap<String, ExperimentalTechnique>();
        for (ExperimentalTechnique exp : ExperimentalTechnique.values()) {
            expTechStr2Value.put(exp.getName(), exp);
        }
        return expTechStr2Value;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCrystallographic() {
        return this.isCrystallographic;
    }

    public boolean isNmr() {
        return this.isNmr;
    }

    public static ExperimentalTechnique getByName(String expTechniqueName) {
        return expTechStr2Value.get(expTechniqueName);
    }

    public static boolean isCrystallographic(Set<ExperimentalTechnique> techniques) {
        for (ExperimentalTechnique et : techniques) {
            if (!et.isCrystallographic()) continue;
            return true;
        }
        return false;
    }

    public static boolean isNmr(Set<ExperimentalTechnique> techniques) {
        for (ExperimentalTechnique et : techniques) {
            if (!et.isNmr()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    static {
        expTechStr2Value = ExperimentalTechnique.initExpTechStr2Value();
    }
}

