/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.io.LocalPDBDirectory;
import org.biojava.nbio.structure.io.mmcif.SimpleMMcifConsumer;
import org.biojava.nbio.structure.io.mmcif.SimpleMMcifParser;

public class MMCIFFileReader
extends LocalPDBDirectory {
    public static final String[] MMCIF_SPLIT_DIR = new String[]{"data", "structures", "divided", "mmCIF"};
    public static final String[] MMCIF_OBSOLETE_DIR = new String[]{"data", "structures", "obsolete", "mmCIF"};
    private SimpleMMcifConsumer consumer;

    public static void main(String[] args) throws Exception {
        MMCIFFileReader reader = new MMCIFFileReader();
        FileParsingParameters params = new FileParsingParameters();
        reader.setFileParsingParameters(params);
        Structure struc = reader.getStructureById("1m4x");
        System.out.println(struc);
        System.out.println(struc.toPDB());
    }

    public MMCIFFileReader() {
        this(null);
    }

    public MMCIFFileReader(String path) {
        super(path);
        this.addExtension(".cif");
        this.addExtension(".mmcif");
        this.addExtension(".cif.gz");
        this.addExtension(".mmcif.gz");
    }

    @Override
    public Structure getStructure(InputStream inStream) throws IOException {
        SimpleMMcifParser parser = new SimpleMMcifParser();
        this.consumer = new SimpleMMcifConsumer();
        this.consumer.setFileParsingParameters(this.getFileParsingParameters());
        parser.addMMcifConsumer(this.consumer);
        parser.parse(new BufferedReader(new InputStreamReader(inStream)));
        Structure cifStructure = this.consumer.getStructure();
        return cifStructure;
    }

    public SimpleMMcifConsumer getMMcifConsumer() {
        return this.consumer;
    }

    @Override
    protected String getFilename(String pdbId) {
        return pdbId.toLowerCase() + ".cif.gz";
    }

    @Override
    protected String[] getSplitDirPath() {
        return MMCIF_SPLIT_DIR;
    }

    @Override
    protected String[] getObsoleteDirPath() {
        return MMCIF_OBSOLETE_DIR;
    }
}

