/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.mmcif;

import java.util.List;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.io.mmcif.ChemicalComponentDictionary;
import org.biojava.nbio.structure.io.mmcif.MMcifConsumer;
import org.biojava.nbio.structure.io.mmcif.chem.ResidueType;
import org.biojava.nbio.structure.io.mmcif.model.AtomSite;
import org.biojava.nbio.structure.io.mmcif.model.AtomSites;
import org.biojava.nbio.structure.io.mmcif.model.AuditAuthor;
import org.biojava.nbio.structure.io.mmcif.model.Cell;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.biojava.nbio.structure.io.mmcif.model.ChemCompAtom;
import org.biojava.nbio.structure.io.mmcif.model.ChemCompBond;
import org.biojava.nbio.structure.io.mmcif.model.ChemCompDescriptor;
import org.biojava.nbio.structure.io.mmcif.model.DatabasePDBremark;
import org.biojava.nbio.structure.io.mmcif.model.DatabasePDBrev;
import org.biojava.nbio.structure.io.mmcif.model.DatabasePdbrevRecord;
import org.biojava.nbio.structure.io.mmcif.model.Entity;
import org.biojava.nbio.structure.io.mmcif.model.EntityPolySeq;
import org.biojava.nbio.structure.io.mmcif.model.EntitySrcGen;
import org.biojava.nbio.structure.io.mmcif.model.EntitySrcNat;
import org.biojava.nbio.structure.io.mmcif.model.EntitySrcSyn;
import org.biojava.nbio.structure.io.mmcif.model.Exptl;
import org.biojava.nbio.structure.io.mmcif.model.PdbxChemCompDescriptor;
import org.biojava.nbio.structure.io.mmcif.model.PdbxChemCompIdentifier;
import org.biojava.nbio.structure.io.mmcif.model.PdbxEntityNonPoly;
import org.biojava.nbio.structure.io.mmcif.model.PdbxNonPolyScheme;
import org.biojava.nbio.structure.io.mmcif.model.PdbxPolySeqScheme;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructAssembly;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructAssemblyGen;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructOperList;
import org.biojava.nbio.structure.io.mmcif.model.Refine;
import org.biojava.nbio.structure.io.mmcif.model.Struct;
import org.biojava.nbio.structure.io.mmcif.model.StructAsym;
import org.biojava.nbio.structure.io.mmcif.model.StructConn;
import org.biojava.nbio.structure.io.mmcif.model.StructKeywords;
import org.biojava.nbio.structure.io.mmcif.model.StructNcsOper;
import org.biojava.nbio.structure.io.mmcif.model.StructRef;
import org.biojava.nbio.structure.io.mmcif.model.StructRefSeq;
import org.biojava.nbio.structure.io.mmcif.model.StructRefSeqDif;
import org.biojava.nbio.structure.io.mmcif.model.StructSite;
import org.biojava.nbio.structure.io.mmcif.model.StructSiteGen;
import org.biojava.nbio.structure.io.mmcif.model.Symmetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChemCompConsumer
implements MMcifConsumer {
    private static final Logger logger = LoggerFactory.getLogger(ChemCompConsumer.class);
    ChemicalComponentDictionary dictionary = new ChemicalComponentDictionary();
    String latestChemCompId;

    @Override
    public void documentStart() {
    }

    public ChemicalComponentDictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public void newChemComp(ChemComp c) {
        if (c.getId() == null) {
            logger.warn("chem comp ID == null " + c);
        }
        this.latestChemCompId = c.getId();
        this.dictionary.addChemComp(c);
        if (c.getResidueType() == ResidueType.nonPolymer) {
            return;
        }
        if (c.getResidueType() == ResidueType.saccharide) {
            return;
        }
        if (c.getResidueType() == ResidueType.dSaccharide) {
            return;
        }
    }

    @Override
    public void documentEnd() {
    }

    @Override
    public void newAtomSite(AtomSite atom) {
    }

    @Override
    public void newDatabasePDBremark(DatabasePDBremark remark) {
    }

    @Override
    public void newDatabasePDBrev(DatabasePDBrev dbrev) {
    }

    @Override
    public void newDatabasePDBrevRecord(DatabasePdbrevRecord dbrev) {
    }

    @Override
    public void newEntity(Entity entity) {
    }

    @Override
    public void newEntityPolySeq(EntityPolySeq epolseq) {
    }

    @Override
    public void newExptl(Exptl exptl) {
    }

    @Override
    public void newCell(Cell cell) {
    }

    @Override
    public void newSymmetry(Symmetry symmetry) {
    }

    @Override
    public void newStructNcsOper(StructNcsOper sNcsOper) {
    }

    @Override
    public void newAtomSites(AtomSites atomSites) {
    }

    @Override
    public void newPdbxEntityNonPoly(PdbxEntityNonPoly pen) {
    }

    @Override
    public void newPdbxNonPolyScheme(PdbxNonPolyScheme ppss) {
    }

    @Override
    public void newPdbxPolySeqScheme(PdbxPolySeqScheme ppss) {
    }

    @Override
    public void newRefine(Refine r) {
    }

    @Override
    public void newStructAsym(StructAsym sasym) {
    }

    @Override
    public void newStructKeywords(StructKeywords kw) {
    }

    @Override
    public void newStructRef(StructRef sref) {
    }

    @Override
    public void newStructRefSeq(StructRefSeq sref) {
    }

    @Override
    public void newStructRefSeqDif(StructRefSeqDif sref) {
    }

    @Override
    public void setStruct(Struct struct) {
    }

    @Override
    public void newGenericData(String category, List<String> loopFields, List<String> lineData) {
    }

    @Override
    public void newAuditAuthor(AuditAuthor aa) {
    }

    @Override
    public FileParsingParameters getFileParsingParameters() {
        return null;
    }

    @Override
    public void setFileParsingParameters(FileParsingParameters params) {
    }

    @Override
    public void newChemCompDescriptor(ChemCompDescriptor ccd) {
        ChemComp cc = this.dictionary.getChemComp(this.latestChemCompId);
        cc.getDescriptors().add(ccd);
    }

    @Override
    public void newPdbxStructOperList(PdbxStructOperList structOper) {
    }

    @Override
    public void newPdbxStrucAssembly(PdbxStructAssembly strucAssembly) {
    }

    @Override
    public void newPdbxStrucAssemblyGen(PdbxStructAssemblyGen strucAssembly) {
    }

    @Override
    public void newChemCompAtom(ChemCompAtom atom) {
        this.dictionary.getChemComp(this.latestChemCompId).getAtoms().add(atom);
    }

    @Override
    public void newPdbxChemCompIndentifier(PdbxChemCompIdentifier id) {
    }

    @Override
    public void newChemCompBond(ChemCompBond bond) {
        this.dictionary.getChemComp(this.latestChemCompId).getBonds().add(bond);
    }

    @Override
    public void newPdbxChemCompDescriptor(PdbxChemCompDescriptor desc) {
    }

    @Override
    public void newEntitySrcGen(EntitySrcGen entitySrcGen) {
    }

    @Override
    public void newEntitySrcNat(EntitySrcNat entitySrcNat) {
    }

    @Override
    public void newEntitySrcSyn(EntitySrcSyn entitySrcSyn) {
    }

    @Override
    public void newStructConn(StructConn structConn) {
    }

    @Override
    public void newStructSiteGen(StructSiteGen gen) {
    }

    @Override
    public void newStructSite(StructSite site) {
    }
}

