/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.io.mmcif.chem.PolymerType;
import org.biojava.nbio.structure.io.mmcif.chem.ResidueType;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProteinChainExtractor {
    private static final Logger logger = LoggerFactory.getLogger(ProteinChainExtractor.class);
    private Structure structure = null;
    private QuatSymmetryParameters parameters = null;
    private boolean modified = true;
    private int adjustedMinimumSequenceLength = 0;
    private List<Atom[]> cAlphaTrace = new ArrayList<Atom[]>();
    private List<String> chainIds = new ArrayList<String>();
    private List<Integer> modelNumbers = new ArrayList<Integer>();
    private List<String> sequences = new ArrayList<String>();
    private int nucleicAcidChainCount = 0;

    public ProteinChainExtractor(Structure structure, QuatSymmetryParameters parameters) {
        this.structure = structure;
        this.parameters = parameters;
        this.modified = true;
    }

    public List<Atom[]> getCalphaTraces() {
        this.run();
        return this.cAlphaTrace;
    }

    public List<String> getChainIds() {
        this.run();
        return this.chainIds;
    }

    public List<Integer> getModelNumbers() {
        this.run();
        return this.modelNumbers;
    }

    public List<String> getSequences() {
        this.run();
        return this.sequences;
    }

    public int getNucleicAcidChainCount() {
        this.run();
        return this.nucleicAcidChainCount;
    }

    public int getAdjustedMinimumSequenceLength() {
        this.run();
        return this.adjustedMinimumSequenceLength;
    }

    private void run() {
        if (this.modified) {
            this.calcAdjustedMinimumSequenceLength();
            this.extractProteinChains();
            this.modified = false;
        }
    }

    private void extractProteinChains() {
        int models = 1;
        if (this.structure.isBiologicalAssembly()) {
            models = this.structure.nrModels();
        }
        if (this.parameters.isVerbose()) {
            System.out.println("Protein chains used in calculation:");
            System.out.println("Adjusted minimum sequence length: " + this.adjustedMinimumSequenceLength);
        }
        for (int i = 0; i < models; ++i) {
            for (Chain c : this.structure.getChains(i)) {
                if (this.isNucleicAcidChain(c)) {
                    ++this.nucleicAcidChainCount;
                }
                Atom[] ca = StructureTools.getAtomCAArray(c);
                if ((ca = this.retainStandardAminoAcidResidues(ca)).length < this.adjustedMinimumSequenceLength) continue;
                if (this.parameters.isVerbose()) {
                    System.out.println("Chain " + c.getChainID() + " Calpha atoms: " + ca.length + " seqres: " + c.getSeqResSequence());
                }
                this.cAlphaTrace.add(ca);
                this.chainIds.add(c.getChainID());
                this.modelNumbers.add(i);
                this.sequences.add(this.replaceQuestionMarks(c.getSeqResSequence()));
            }
        }
    }

    private void calcAdjustedMinimumSequenceLength() {
        int models = 1;
        if (this.structure.isBiologicalAssembly()) {
            models = this.structure.nrModels();
        }
        int maxLength = Integer.MIN_VALUE;
        int minLength = Integer.MAX_VALUE;
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        for (int i = 0; i < models; ++i) {
            for (Chain c : this.structure.getChains(i)) {
                Atom[] ca = StructureTools.getAtomCAArray(c);
                if ((ca = this.retainStandardAminoAcidResidues(ca)).length < this.parameters.getAbsoluteMinimumSequenceLength()) continue;
                maxLength = Math.max(ca.length, maxLength);
                minLength = Math.min(ca.length, minLength);
                lengths.add(ca.length);
            }
        }
        this.adjustedMinimumSequenceLength = this.parameters.getMinimumSequenceLength();
        if (lengths.size() < 2) {
            return;
        }
        double median = 0.0;
        Collections.sort(lengths);
        if (lengths.size() % 2 == 1) {
            int middle = (lengths.size() - 1) / 2;
            median = ((Integer)lengths.get(middle)).intValue();
        } else {
            int middle2 = lengths.size() / 2;
            int middle1 = middle2 - 1;
            median = 0.5 * (double)((Integer)lengths.get(middle1) + (Integer)lengths.get(middle2));
        }
        if ((double)minLength >= median * this.parameters.getMinimumSequenceLengthFraction()) {
            this.adjustedMinimumSequenceLength = Math.min(minLength, this.parameters.getMinimumSequenceLength());
        }
    }

    private boolean isNucleicAcidChain(Chain chain) {
        int count = 0;
        for (Group group : chain.getAtomGroups()) {
            PolymerType type = group.getChemComp().getPolymerType();
            if (type == null || !type.equals(PolymerType.dna) && !type.equals(PolymerType.rna) && !type.equals(PolymerType.dnarna)) continue;
            ++count;
        }
        return count > 3;
    }

    private String replaceQuestionMarks(String sequence) {
        return sequence.replaceAll("\\?", "X");
    }

    private Atom[] retainStandardAminoAcidResidues(Atom[] atoms) {
        ArrayList<Atom> atomList = new ArrayList<Atom>(atoms.length);
        for (Atom atom : atoms) {
            Group group = atom.getGroup();
            if (group.getPDBName().equalsIgnoreCase("UNK") || !this.isAminoAcid(group)) continue;
            atomList.add(atom);
        }
        return atomList.toArray(new Atom[atomList.size()]);
    }

    private boolean isAminoAcid(Group group) {
        ChemComp cc = group.getChemComp();
        if (cc.getResidueType() == null) {
            logger.warn("null residue type for: " + group.getPDBName());
            return false;
        }
        return cc.getResidueType().equals(ResidueType.lPeptideLinking) || cc.getResidueType().equals(ResidueType.glycine);
    }
}

