/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.fatcat.calc;

import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.SVDSuperimposer;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.AFPTwister;
import org.biojava.nbio.structure.align.fatcat.calc.FatCatParameters;
import org.biojava.nbio.structure.align.model.AFP;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.jama.Matrix;

public class AFPChainer {
    public static final boolean debug = false;

    public static void doChainAfp(FatCatParameters params, AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        List<AFP> afpSet = afpChain.getAfpSet();
        afpChain.setConn(0.0);
        afpChain.setDVar(0.0);
        int afpNum = afpSet.size();
        if (afpNum <= 0) {
            return;
        }
        int[] twi = afpChain.getTwi();
        if (twi == null) {
            twi = new int[afpNum];
            afpChain.setTwi(twi);
        }
        boolean isConnected = false;
        afpChain.setConn(0.0);
        afpChain.setDVar(0.0);
        double[] sco = new double[afpNum];
        int[] pre = new int[afpNum];
        double maxsco = 0.0;
        int maxafp = 0;
        int[] list = new int[afpNum];
        int maxGap = params.getMaxGap();
        int fragLen = params.getFragLen();
        int maxTra = params.getMaxTra();
        Matrix disTable1 = AFPChainer.getDisTable(maxGap + 2 * fragLen + 1, ca1);
        Matrix disTable2 = AFPChainer.getDisTable(maxGap + 2 * fragLen + 1, ca2);
        afpChain.setDisTable1(disTable1);
        afpChain.setDisTable2(disTable2);
        for (int i = 0; i < afpNum; ++i) {
            sco[i] = afpSet.get(i).getScore();
            pre[i] = -1;
            twi[i] = 0;
            int n = afpSet.get(i).getP1() < fragLen || afpSet.get(i).getP2() < fragLen ? 0 : AFPChainer.getCompatibleAfps(i, list, params, afpChain);
            for (int j0 = 0; j0 < n; ++j0) {
                double stmp;
                int j = list[j0];
                isConnected = AFPChainer.afpPairConn(j, i, params, afpChain);
                Double conn = afpChain.getConn();
                int t = 0;
                if (isConnected) {
                    t = 1;
                }
                if (twi[j] + t > maxTra || !((stmp = sco[j] + afpSet.get(i).getScore() + conn) > sco[i])) continue;
                sco[i] = stmp;
                twi[i] = twi[j] + t;
                pre[i] = j;
            }
            if (!(maxsco < sco[i])) continue;
            maxsco = sco[i];
            maxafp = i;
        }
        int currafp = maxafp;
        afpChain.setAlignScore(maxsco);
        afpChain.setAlignScoreUpdate(maxsco);
        afpChain.setAfpChainTwiNum(0);
        AFPChainer.traceBack(pre, currafp, twi[currafp], params, afpChain, ca1, ca2);
    }

    private static Matrix getDisTable(int maxlen, Atom[] ca) {
        int length = ca.length;
        Matrix dis = new Matrix(length, length);
        for (int i = 0; i < length; ++i) {
            dis.set(i, i, 0.0);
            for (int j = i + 1; j < length && j <= i + maxlen; ++j) {
                dis.set(i, j, 0.0);
                double val = dis.get(i, j) + Calc.getDistance(ca[i], ca[j]) * Calc.getDistance(ca[i], ca[j]);
                dis.set(i, j, val);
                dis.set(i, j, Math.sqrt(dis.get(i, j)));
                dis.set(j, i, dis.get(i, j));
            }
        }
        return dis;
    }

    private static int getCompatibleAfps(int afp, int[] list, FatCatParameters params, AFPChain afpChain) {
        int j;
        int s2;
        int s1;
        int i;
        int fragLen = params.getFragLen();
        int maxGapFrag = params.getMaxGapFrag();
        int misCut = params.getMisCut();
        int maxTra = params.getMaxTra();
        List<AFP> afpSet = afpChain.getAfpSet();
        int f = fragLen;
        int G = maxGapFrag;
        int c = misCut;
        int i1 = afpSet.get(afp).getP1();
        int j1 = afpSet.get(afp).getP2();
        int a3 = i1 - f;
        int a2 = a3 - c;
        int a1 = i1 - G;
        a2 = a2 > 0 ? a2 : 0;
        a1 = a1 > 0 ? a1 : 0;
        int b3 = j1 - f;
        int b2 = b3 - c;
        int b1 = j1 - G;
        b2 = b2 > 0 ? b2 : 0;
        b1 = b1 > 0 ? b1 : 0;
        int[][] afpAftIndex = afpChain.getAfpAftIndex();
        int[][] afpBefIndex = afpChain.getAfpBefIndex();
        int[] twi = afpChain.getTwi();
        int n = 0;
        for (i = a1; i <= a3; ++i) {
            s1 = afpAftIndex[i][b2];
            if (s1 < 0 || (s2 = afpBefIndex[i][b3]) < 0) continue;
            for (j = s1; j <= s2; ++j) {
                if (twi[j] > maxTra) continue;
                list[n++] = j;
            }
        }
        for (i = a2; i <= a3; ++i) {
            s1 = afpAftIndex[i][b1];
            if (s1 < 0 || (s2 = afpBefIndex[i][b2]) < 0) continue;
            for (j = s1; j < s2; ++j) {
                if (twi[j] > maxTra) continue;
                list[n++] = j;
            }
        }
        return n;
    }

    public static boolean afpPairConn(int afp1, int afp2, FatCatParameters params, AFPChain afpChain) {
        Double conn = afpChain.getConn();
        Double dvar = afpChain.getDVar();
        double misScore = params.getMisScore();
        double maxPenalty = params.getMaxPenalty();
        double disCut = params.getDisCut();
        double gapExtend = params.getGapExtend();
        double torsionPenalty = params.getTorsionPenalty();
        double disSmooth = params.getDisSmooth();
        List<AFP> afpSet = afpChain.getAfpSet();
        int m = AFPChainer.calcGap(afpSet.get(afp2), afpSet.get(afp1));
        int g = AFPChainer.calcMismatch(afpSet.get(afp2), afpSet.get(afp1));
        double gp = misScore * (double)m;
        if (g > 0) {
            gp += gapExtend * (double)g;
        }
        if (gp < maxPenalty) {
            gp = maxPenalty;
        }
        double d = AFPChainer.calAfpDis(afp1, afp2, params, afpChain);
        boolean ch = false;
        double tp = 0.0;
        if (d >= disCut) {
            tp = torsionPenalty;
            ch = true;
        } else if (d > disCut - disSmooth) {
            double wt = Math.sqrt((d - disCut + disSmooth) / disSmooth);
            tp = torsionPenalty * wt;
        }
        dvar = d;
        conn = tp + gp;
        afpChain.setConn(conn);
        afpChain.setDVar(dvar);
        return ch;
    }

    private static int calcGap(AFP afp1, AFP afp2) {
        int g = afp1.getP1() - afp2.getP1() - (afp1.getP2() - afp2.getP2());
        if (g < 0) {
            g = -g;
        }
        return g;
    }

    private static int calcMismatch(AFP afp1, AFP afp2) {
        int l2;
        int l1 = afp1.getP1() - afp2.getP1() - afp2.getFragLen();
        return l1 > (l2 = afp1.getP2() - afp2.getP2() - afp2.getFragLen()) ? l2 : l1;
    }

    private static double calAfpDis(int afp1, int afp2, FatCatParameters params, AFPChain afpChain) {
        List<AFP> afpSet = afpChain.getAfpSet();
        Matrix disTable1 = afpChain.getDisTable1();
        Matrix disTable2 = afpChain.getDisTable2();
        int fragLen = params.getFragLen();
        double afpDisCut = params.getAfpDisCut();
        double disCut = params.getDisCut();
        double fragLenSq = params.getFragLenSq();
        double rms = 0.0;
        for (int i = 0; i < fragLen; ++i) {
            int ai = afpSet.get(afp1).getP1() + i;
            int bi = afpSet.get(afp1).getP2() + i;
            for (int j = 0; j < fragLen; ++j) {
                int aj = afpSet.get(afp2).getP1() + j;
                int bj = afpSet.get(afp2).getP2() + j;
                double d = disTable1.get(aj, ai) - disTable2.get(bj, bi);
                if (!((rms += d * d) > afpDisCut)) continue;
                return disCut;
            }
        }
        return Math.sqrt(rms / fragLenSq);
    }

    private static void traceBack(int[] pre, int currafp0, int twist, FatCatParameters params, AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        int i;
        int prevafp;
        afpChain.setConn(0.0);
        afpChain.setDVar(0.0);
        int minLen = afpChain.getMinLen();
        List<AFP> afpSet = afpChain.getAfpSet();
        int afpChainLen = 0;
        int[] afpchain = new int[minLen];
        int[] afptwibin = new int[minLen];
        double[] afptwilist = new double[minLen];
        int currafp = currafp0;
        int s = 0;
        afptwibin[s] = 0;
        afpchain[s++] = currafp;
        boolean isConnected = false;
        while ((prevafp = pre[currafp]) != -1) {
            isConnected = AFPChainer.afpPairConn(prevafp, currafp, params, afpChain);
            afptwibin[s - 1] = isConnected ? 1 : 0;
            Double dvar = afpChain.getDVar();
            afptwilist[s - 1] = dvar;
            currafp = prevafp;
            afpchain[s++] = currafp;
        }
        afpChainLen = s;
        afpChain.setAfpChainLen(afpChainLen);
        afptwibin[s - 1] = isConnected ? 1 : 0;
        int[] afpChainList = afpChain.getAfpChainList();
        double[] afpChainTwiBin = afpChain.getAfpChainTwiBin();
        double[] afpChainTwiList = afpChain.getAfpChainTwiList();
        if (afpChainList == null) {
            afpChainList = new int[s];
            afpChain.setAfpChainList(afpChainList);
            afpChainTwiBin = new double[s];
            afpChain.setAfpChainTwiBin(afpChainTwiBin);
            afpChainTwiList = new double[s];
            afpChain.setAfpChainTwiList(afpChainTwiList);
        }
        int afpChainTwiNum = afpChain.getAfpChainTwiNum();
        for (i = 0; i < s; ++i) {
            afpChainList[i] = afpchain[s - 1 - i];
            afpChainTwiBin[i] = afptwibin[s - 1 - i];
            afpChainTwiList[i] = afptwilist[s - 1 - i];
            afpChainTwiNum += afptwibin[s - 1 - i];
        }
        if (afpChainTwiNum != twist) {
            System.err.println(String.format("AFPChainer Warning: the twists number is not consistent %d %d\n", afpChainTwiNum, twist));
        }
        double alignScore = afpChain.getAlignScore();
        double checkscore = afpSet.get(afpChainList[0]).getScore();
        for (i = 1; i < afpChainLen; ++i) {
            isConnected = AFPChainer.afpPairConn(afpChainList[i - 1], afpChainList[i], params, afpChain);
            checkscore = checkscore + afpSet.get(afpChainList[i]).getScore() + afpChain.getConn();
        }
        if (Math.abs(checkscore - alignScore) > 1.0E-4) {
            System.err.println(String.format("AFPChainer Warning: fail in alignment score checking %.4f %.4f\n", alignScore, checkscore));
        }
        double rmsd = AFPChainer.calAfpRmsd(afpChainLen, afpChainList, 0, afpChain, ca1, ca2);
        afpChain.setChainRmsd(rmsd);
        int b1 = 0;
        int bk = 0;
        afpChain.setChainLen(0);
        int chainLen = afpChain.getChainLen();
        int[] block2Afp = afpChain.getBlock2Afp();
        double[] blockRmsd = afpChain.getBlockRmsd();
        int[] blockSize = afpChain.getBlockSize();
        block2Afp[0] = 0;
        for (i = 0; i < afpChainLen; ++i) {
            int a = afpChainList[i];
            chainLen += afpSet.get(a).getFragLen();
            if (i > 0) {
                int b = afpChainList[i - 1];
                int misLen = afpChain.getMisLen();
                afpChain.setMisLen(misLen += AFPChainer.calcMismatch(afpSet.get(a), afpSet.get(b)));
                int gapLen = afpChain.getGapLen();
                afpChain.setGapLen(gapLen += AFPChainer.calcGap(afpSet.get(a), afpSet.get(b)));
            }
            if (afpChainTwiBin[i] != 1.0) continue;
            blockRmsd[bk] = rmsd = AFPChainer.calAfpRmsd(i - b1, afpChainList, b1, afpChain, ca1, ca2);
            blockSize[bk] = i - b1;
            b1 = i;
            block2Afp[++bk] = i;
        }
        afpChain.setBlock2Afp(block2Afp);
        afpChain.setChainLen(chainLen);
        rmsd = AFPChainer.calAfpRmsd(i - b1, afpChainList, b1, afpChain, ca1, ca2);
        blockSize[bk] = i - b1;
        blockRmsd[bk] = rmsd;
        afpChain.setBlockSize(blockSize);
        afpChain.setBlockRmsd(blockRmsd);
        int blockNum = afpChain.getBlockNum();
        blockNum = ++bk;
        afpChain.setBlockNum(blockNum);
        afpChain.setAfpChainList(afpChainList);
        afpChain.setAfpChainTwiList(afpChainTwiList);
    }

    protected static double calAfpRmsd(int afpn, int[] afpPositions, int listStart, AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        int focusResn = AFPTwister.afp2Res(afpChain, afpn, afpPositions, listStart);
        int[] focusRes1 = afpChain.getFocusRes1();
        int[] focusRes2 = afpChain.getFocusRes2();
        double rmsd = AFPChainer.getRmsd(focusResn, focusRes1, focusRes2, afpChain, ca1, ca2);
        return rmsd;
    }

    private static double getRmsd(int focusResn, int[] focusRes1, int[] focusRes2, AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        Atom[] tmp1 = new Atom[focusResn];
        Atom[] tmp2 = new Atom[focusResn];
        for (int i = 0; i < focusResn; ++i) {
            tmp1[i] = ca1[focusRes1[i]];
            tmp2[i] = (Atom)ca2[focusRes2[i]].clone();
            if (tmp1[i].getCoords() == null) {
                System.err.println("tmp1 got null: " + i + " pos: " + focusRes1[i]);
            }
            if (tmp2[i].getCoords() != null) continue;
            System.err.println("tmp1 got null: " + i + " pos: " + focusRes2[i]);
        }
        double rmsd = 99.0;
        try {
            rmsd = AFPChainer.getRmsd(tmp1, tmp2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rmsd;
    }

    private static double getRmsd(Atom[] catmp1, Atom[] catmp2) throws StructureException {
        SVDSuperimposer svd = new SVDSuperimposer(catmp1, catmp2);
        Matrix m = svd.getRotation();
        Atom t = svd.getTranslation();
        for (Atom a : catmp2) {
            Calc.rotate(a, m);
            Calc.shift(a, t);
        }
        double rmsd = SVDSuperimposer.getRMS(catmp1, catmp2);
        return rmsd;
    }
}

