/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.pairwise;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.List;
import java.util.logging.Logger;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomImpl;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.SVDSuperimposer;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureImpl;
import org.biojava.nbio.structure.align.StrucAligParameters;
import org.biojava.nbio.structure.align.helper.AligMatEl;
import org.biojava.nbio.structure.align.helper.IndexPair;
import org.biojava.nbio.structure.align.helper.JointFragments;
import org.biojava.nbio.structure.align.pairwise.Alignable;
import org.biojava.nbio.structure.align.pairwise.FragmentJoiner;
import org.biojava.nbio.structure.align.pairwise.Gotoh;
import org.biojava.nbio.structure.align.pairwise.StrCompAlignment;
import org.biojava.nbio.structure.jama.Matrix;

public class AlternativeAlignment
implements Serializable {
    private static final long serialVersionUID = -6226717654562221241L;
    int[] idx1;
    int[] idx2;
    String[] pdbresnum1;
    String[] pdbresnum2;
    int nfrags = 0;
    Atom center;
    Matrix rot = null;
    Atom tr;
    int gaps0 = -99;
    int eqr0 = -99;
    int rms0 = 99;
    int joined = 0;
    int percId;
    int cluster;
    float score;
    IndexPair[] aligpath = new IndexPair[0];
    int fromia = 0;
    Matrix currentRotMatrix;
    Atom currentTranMatrix;
    double rms;
    Matrix distanceMatrix;
    public static Logger logger = Logger.getLogger("org.biojava.nbio.structure.align");

    public AlternativeAlignment() {
        this.idx1 = new int[0];
        this.idx2 = new int[0];
        this.center = new AtomImpl();
        this.tr = new AtomImpl();
        this.currentRotMatrix = new Matrix(0, 0);
        this.currentTranMatrix = new AtomImpl();
        this.distanceMatrix = new Matrix(0, 0);
    }

    public String toString() {
        DecimalFormat d2 = new DecimalFormat();
        d2.setMaximumIntegerDigits(3);
        d2.setMinimumFractionDigits(2);
        d2.setMaximumFractionDigits(2);
        StringBuffer s = new StringBuffer();
        s.append("#" + this.getAltAligNumber() + " cluster:" + this.cluster + " eqr:" + this.getEqr() + " rmsd:" + d2.format(this.getRmsd()) + " %id:" + this.getPercId() + " gaps:" + this.getGaps() + " score:" + d2.format(this.score));
        return s.toString();
    }

    public int getCluster() {
        return this.cluster;
    }

    public void setCluster(int cluster) {
        this.cluster = cluster;
    }

    public double getRmsd() {
        return this.rms;
    }

    public void setRms(double rms) {
        this.rms = rms;
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public int getGaps() {
        return this.gaps0;
    }

    public int getEqr() {
        return this.eqr0;
    }

    public int[] getIdx1() {
        return this.idx1;
    }

    public int[] getIdx2() {
        return this.idx2;
    }

    public int getPercId() {
        return this.percId;
    }

    public void setPercId(int percId) {
        this.percId = percId;
    }

    public void apairs_from_seed(int l, int i, int j) {
        this.aligpath = new IndexPair[l];
        this.idx1 = new int[l];
        this.idx2 = new int[l];
        for (int x = 0; x < l; ++x) {
            this.idx1[x] = i + x;
            this.idx2[x] = j + x;
            this.aligpath[x] = new IndexPair((short)(i + x), (short)(j + x));
        }
    }

    public void apairs_from_idxlst(JointFragments jf) {
        List<int[]> il = jf.getIdxlist();
        this.aligpath = new IndexPair[il.size()];
        this.idx1 = new int[il.size()];
        this.idx2 = new int[il.size()];
        for (int i = 0; i < il.size(); ++i) {
            int[] p = il.get(i);
            this.idx1[i] = p[0];
            this.idx2[i] = p[1];
            this.aligpath[i] = new IndexPair((short)p[0], (short)p[1]);
        }
        this.eqr0 = this.idx1.length;
        this.gaps0 = this.count_gaps(this.idx1, this.idx2);
    }

    public int getAltAligNumber() {
        return this.fromia;
    }

    public void setAltAligNumber(int fromia) {
        this.fromia = fromia;
    }

    private void rotateShiftAtoms(Atom[] ca) {
        for (int i = 0; i < ca.length; ++i) {
            Atom c = ca[i];
            Calc.rotate(c, this.currentRotMatrix);
            Calc.shift(c, this.currentTranMatrix);
            ca[i] = c;
        }
    }

    public void finish(StrucAligParameters params, Atom[] ca1, Atom[] ca2) throws StructureException {
        Atom[] ca3 = new Atom[ca2.length];
        for (int i = 0; i < ca2.length; ++i) {
            ca3[i] = (Atom)ca2[i].clone();
        }
        this.super_pos_alig(ca1, ca3, this.idx1, this.idx2, true);
        this.rotateShiftAtoms(ca3);
        this.calcScores(ca1, ca2);
        logger.fine("eqr " + this.eqr0 + " " + this.gaps0 + " " + this.idx1[0] + " " + this.idx1[1]);
        this.getPdbRegions(ca1, ca2);
    }

    public static Matrix getDistanceMatrix(Atom[] ca1, Atom[] ca2) {
        int r = ca1.length;
        int c = ca2.length;
        Matrix out = new Matrix(r, c);
        for (int i = 0; i < r; ++i) {
            Atom a1 = ca1[i];
            for (int j = 0; j < c; ++j) {
                Atom b1 = ca2[j];
                double d = Calc.getDistance(a1, b1);
                out.set(i, j, d);
            }
        }
        return out;
    }

    private Alignable getInitalStrCompAlignment(Atom[] ca1, Atom[] ca2, StrucAligParameters params) {
        int rows = ca1.length;
        int cols = ca2.length;
        float gapOpen = params.getGapOpen();
        float gapExtension = params.getGapExtension();
        float co = params.getCreate_co();
        StrCompAlignment al = new StrCompAlignment(rows, cols);
        al.setGapExtCol(gapExtension);
        al.setGapExtRow(gapExtension);
        al.setGapOpenCol(gapOpen);
        al.setGapOpenRow(gapOpen);
        AligMatEl[][] aligmat = al.getAligMat();
        aligmat[0][cols] = new AligMatEl();
        aligmat[rows][0] = new AligMatEl();
        aligmat[rows][cols] = new AligMatEl();
        for (int i = 0; i < rows; ++i) {
            Atom a1 = ca1[i];
            aligmat[i][0] = new AligMatEl();
            for (int j = 0; j < cols; ++j) {
                aligmat[0][j] = new AligMatEl();
                Atom b1 = ca2[j];
                double d = 999.0;
                d = Calc.getDistance(a1, b1);
                AligMatEl e = new AligMatEl();
                if (d > (double)co) {
                    e.setValue(0);
                } else {
                    double s = (double)(2.0f * co) / (1.0 + d / (double)co * (d / (double)co)) - (double)co;
                    e.setValue((int)Math.round((double)Gotoh.ALIGFACTOR * s));
                }
                aligmat[i + 1][j + 1] = e;
            }
        }
        return al;
    }

    public void refine(StrucAligParameters params, Atom[] ca1, Atom[] ca2) throws StructureException {
        Atom[] ca3 = new Atom[ca2.length];
        for (int i = 0; i < ca2.length; ++i) {
            ca3[i] = (Atom)ca2[i].clone();
        }
        this.super_pos_alig(ca1, ca3, this.idx1, this.idx2, false);
        int lenalt = this.idx1.length;
        int lenneu = this.aligpath.length;
        int ml = Math.max(ca1.length, ca3.length);
        this.idx1 = new int[ml];
        this.idx2 = new int[ml];
        int maxiter = params.getMaxIter();
        for (int iter = 0; iter < maxiter; ++iter) {
            int quadb_end;
            int quadb_beg;
            int quada_end;
            int quada_beg;
            float subscore = 0.0f;
            this.rotateShiftAtoms(ca3);
            Alignable ali = this.getInitalStrCompAlignment(ca1, ca3, params);
            new Gotoh(ali);
            this.score = ali.getScore();
            IndexPair[] path = ali.getPath();
            int pathsize = ali.getPathSize();
            short firsta = path[0].getRow();
            short firstb = path[0].getCol();
            short lasta = path[pathsize - 1].getRow();
            short lastb = path[pathsize - 1].getCol();
            if (firsta == 0) {
                quada_beg = lasta + 1;
                quada_end = ca1.length - 1;
                quadb_beg = 0;
                quadb_end = firstb - 1;
            } else {
                quada_beg = 0;
                quada_end = firsta - 1;
                quadb_beg = lastb + 1;
                quadb_end = ca3.length - 1;
            }
            int permsize = params.getPermutationSize();
            if (permsize > 0 && quada_end - quada_beg >= permsize && quadb_end - quadb_beg >= permsize) {
                AligMatEl[][] aligmat = ali.getAligMat();
                Matrix submat = new Matrix(quada_end - quada_beg, quadb_end - quadb_beg);
                Atom[] tmp1 = new Atom[quada_end - quada_beg];
                Atom[] tmp2 = new Atom[quadb_end - quadb_beg];
                for (int s = quada_beg; s < quada_end; ++s) {
                    tmp1[quada_end - s - 1] = ca1[s];
                    for (int t = quadb_beg; t < quadb_end; ++t) {
                        if (s == quada_beg) {
                            tmp2[quadb_end - t - 1] = ca3[t];
                        }
                        double val = aligmat[s][t].getValue();
                        submat.set(s - quada_beg, t - quadb_beg, val);
                    }
                }
                Alignable subali = this.getInitalStrCompAlignment(tmp1, tmp2, params);
                subscore = subali.getScore();
                this.score += subscore;
                IndexPair[] subpath = subali.getPath();
                int subpathsize = subali.getPathSize();
                for (int p = 0; p < subpath.length; ++p) {
                    IndexPair sp = subpath[p];
                    sp.setRow((short)(sp.getRow() + quada_beg));
                    sp.setCol((short)(sp.getCol() + quadb_beg));
                }
                if (subpathsize > permsize) {
                    int t;
                    IndexPair[] wholepath = new IndexPair[pathsize + subpathsize];
                    for (t = 0; t < pathsize; ++t) {
                        wholepath[t] = path[t];
                    }
                    for (t = 0; t < subpathsize; ++t) {
                        wholepath[t + pathsize] = subpath[t];
                    }
                    path = wholepath;
                    ali.setPath(path);
                    ali.setPathSize(pathsize += subpathsize);
                }
            }
            int j = 0;
            for (int i = 0; i < pathsize; ++i) {
                short y;
                short x = path[i].getRow();
                double d = Calc.getDistance(ca1[x], ca3[y = path[i].getCol()]);
                if (!(d < (double)params.getEvalCutoff())) continue;
                this.idx1[j] = x;
                this.idx2[j] = y;
                ++j;
            }
            lenneu = j;
            int[] tmpidx1 = new int[j];
            int[] tmpidx2 = new int[j];
            for (int i = 0; i < j; ++i) {
                tmpidx1[i] = this.idx1[i];
                tmpidx2[i] = this.idx2[i];
            }
            this.super_pos_alig(ca1, ca3, tmpidx1, tmpidx2, false);
            this.aligpath = path;
            if (lenneu == lenalt) break;
        }
        this.idx1 = (int[])FragmentJoiner.resizeArray(this.idx1, lenneu);
        this.idx2 = (int[])FragmentJoiner.resizeArray(this.idx2, lenneu);
        this.super_pos_alig(ca1, ca2, this.idx1, this.idx2, true);
        this.eqr0 = this.idx1.length;
        this.gaps0 = this.count_gaps(this.idx1, this.idx2);
        this.getPdbRegions(ca1, ca2);
    }

    private void getPdbRegions(Atom[] ca1, Atom[] ca2) {
        this.pdbresnum1 = new String[this.idx1.length];
        this.pdbresnum2 = new String[this.idx2.length];
        for (int i = 0; i < this.idx1.length; ++i) {
            Atom a1 = ca1[this.idx1[i]];
            Atom a2 = ca2[this.idx2[i]];
            Group p1 = a1.getGroup();
            Group p2 = a2.getGroup();
            Chain c1 = p1.getChain();
            Chain c2 = p2.getChain();
            String cid1 = c1.getChainID();
            String cid2 = c2.getChainID();
            String pdb1 = p1.getResidueNumber().toString();
            String pdb2 = p2.getResidueNumber().toString();
            if (!cid1.equals(" ")) {
                pdb1 = pdb1 + ":" + cid1;
            }
            if (!cid2.equals(" ")) {
                pdb2 = pdb2 + ":" + cid2;
            }
            this.pdbresnum1[i] = pdb1;
            this.pdbresnum2[i] = pdb2;
        }
    }

    public String[] getPDBresnum1() {
        return this.pdbresnum1;
    }

    public void setPDBresnum1(String[] pdbresnum1) {
        this.pdbresnum1 = pdbresnum1;
    }

    public String[] getPDBresnum2() {
        return this.pdbresnum2;
    }

    public void setPDBresnum2(String[] pdbresnum2) {
        this.pdbresnum2 = pdbresnum2;
    }

    private int count_gaps(int[] i1, int[] i2) {
        int i0 = i1[0];
        int j0 = i2[0];
        int gaps = 0;
        for (int i = 1; i < i1.length; ++i) {
            if (Math.abs(i1[i] - i0) != 1 || Math.abs(i2[i] - j0) != 1) {
                ++gaps;
            }
            i0 = i1[i];
            j0 = i2[i];
        }
        return gaps;
    }

    public void calculateSuperpositionByIdx(Atom[] ca1, Atom[] ca2) throws StructureException {
        this.super_pos_alig(ca1, ca2, this.idx1, this.idx2, false);
    }

    private void super_pos_alig(Atom[] ca1, Atom[] ca2, int[] idx1, int[] idx2, boolean getRMS) throws StructureException {
        Atom[] ca1subset = new Atom[idx1.length];
        Atom[] ca2subset = new Atom[idx2.length];
        for (int i = 0; i < idx1.length; ++i) {
            int pos1 = idx1[i];
            int pos2 = idx2[i];
            ca1subset[i] = ca1[pos1];
            ca2subset[i] = (Atom)ca2[pos2].clone();
        }
        SVDSuperimposer svd = new SVDSuperimposer(ca1subset, ca2subset);
        this.currentRotMatrix = svd.getRotation();
        this.currentTranMatrix = svd.getTranslation();
        if (getRMS) {
            this.rotateShiftAtoms(ca2subset);
            this.rms = SVDSuperimposer.getRMS(ca1subset, ca2subset);
        }
    }

    public Matrix getRotationMatrix() {
        return this.currentRotMatrix;
    }

    public Atom getShift() {
        return this.currentTranMatrix;
    }

    public void calcScores(Atom[] ca1, Atom[] ca2) {
        this.eqr0 = this.idx1.length;
        this.gaps0 = this.count_gaps(this.idx1, this.idx2);
        this.percId = 0;
        for (int i = 0; i < this.idx1.length; ++i) {
            Atom a1 = ca1[this.idx1[i]];
            Atom a2 = ca2[this.idx2[i]];
            Group g1 = a1.getGroup();
            Group g2 = a2.getGroup();
            if (!g1.getPDBName().equals(g2.getPDBName())) continue;
            ++this.percId;
        }
    }

    public Structure getAlignedStructure(Structure s1, Structure s2) {
        Structure s3 = s2.clone();
        this.currentRotMatrix.print(3, 3);
        Calc.rotate(s3, this.currentRotMatrix);
        Calc.shift(s3, this.currentTranMatrix);
        StructureImpl newpdb = new StructureImpl();
        newpdb.setPDBCode("Java");
        newpdb.setName("Aligned with BioJava");
        newpdb.addModel(s1.getChains(0));
        newpdb.addModel(s3.getChains(0));
        return newpdb;
    }

    public String toPDB(Structure s1, Structure s2) {
        Structure newpdb = this.getAlignedStructure(s1, s2);
        return newpdb.toPDB();
    }

    public Matrix getDistanceMatrix() {
        return this.distanceMatrix;
    }

    public void setDistanceMatrix(Matrix distanceMatrix) {
        this.distanceMatrix = distanceMatrix;
    }

    public IndexPair[] getPath() {
        return this.aligpath;
    }
}

