/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.biojava.nbio.core.util.PrettyXMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class HasResultXMLConverter {
    public String toXML(boolean hasResult) throws IOException {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        PrettyXMLWriter xml = new PrettyXMLWriter(writer);
        xml.openTag("alignment");
        xml.attribute("hasResult", hasResult + "");
        xml.closeTag("alignment");
        xml.close();
        return swriter.toString();
    }

    public boolean fromXML(String xml) {
        boolean hasResult = false;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = factory.newDocumentBuilder();
            InputSource inStream = new InputSource();
            inStream.setCharacterStream(new StringReader(xml));
            Document doc = db.parse(inStream);
            doc.getDocumentElement().normalize();
            NodeList listOfAlignments = doc.getElementsByTagName("alignment");
            for (int afpPos = 0; afpPos < listOfAlignments.getLength(); ++afpPos) {
                Node rootElement = listOfAlignments.item(afpPos);
                String flag = HasResultXMLConverter.getAttribute(rootElement, "hasResult");
                if (!flag.equals("true")) continue;
                hasResult = true;
            }
        }
        catch (SAXParseException err) {
            System.out.println("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            System.out.println(" " + err.getMessage());
        }
        catch (SAXException e) {
            Exception x = e.getException();
            (x == null ? e : x).printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return hasResult;
    }

    private static String getAttribute(Node node, String attr) {
        if (!node.hasAttributes()) {
            return null;
        }
        NamedNodeMap atts = node.getAttributes();
        if (atts == null) {
            return null;
        }
        Node att = atts.getNamedItem(attr);
        if (att == null) {
            return null;
        }
        String value = att.getTextContent();
        return value;
    }
}

