/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.scop;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.biojava.nbio.structure.ResidueRange;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.SubstructureIdentifier;
import org.biojava.nbio.structure.align.util.AtomCache;

@XmlRootElement(name="ScopDomain", namespace="http://source.rcsb.org")
@XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
public class ScopDomain
implements Serializable,
Cloneable,
StructureIdentifier {
    private static final long serialVersionUID = 5890476209571654301L;
    String scopId;
    String pdbId;
    List<String> ranges;
    String classificationId;
    Integer sunid;
    int classId;
    int foldId;
    int superfamilyId;
    int familyId;
    int domainId;
    int speciesId;
    int px;

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.scopId);
        buf.append("\t");
        buf.append(this.pdbId);
        buf.append("\t");
        int rangePos = 0;
        for (String range : this.ranges) {
            buf.append(range);
            if (this.ranges.size() <= 1 || ++rangePos >= this.ranges.size()) continue;
            buf.append(",");
        }
        buf.append("\t");
        buf.append(this.classificationId);
        buf.append("\t");
        buf.append(String.valueOf(this.sunid));
        buf.append("\t");
        buf.append("cl=");
        buf.append(String.valueOf(this.classId));
        buf.append(",cf=");
        buf.append(String.valueOf(this.foldId));
        buf.append(",sf=");
        buf.append(String.valueOf(this.superfamilyId));
        buf.append(",fa=");
        buf.append(String.valueOf(this.familyId));
        buf.append(",dm=");
        buf.append(String.valueOf(this.domainId));
        buf.append(",sp=");
        buf.append(String.valueOf(this.speciesId));
        buf.append(",px=");
        buf.append(String.valueOf(this.px));
        return buf.toString();
    }

    public String getScopId() {
        return this.scopId;
    }

    public void setScopId(String scopId) {
        this.scopId = scopId;
    }

    public String getPdbId() {
        return this.pdbId;
    }

    public void setPdbId(String pdbId) {
        this.pdbId = pdbId;
    }

    public List<String> getRanges() {
        return this.ranges;
    }

    public void setRanges(List<String> ranges) {
        this.ranges = ranges;
    }

    public String getClassificationId() {
        return this.classificationId;
    }

    public void setClassificationId(String classificationId) {
        this.classificationId = classificationId;
    }

    public Integer getSunid() {
        return this.sunid;
    }

    public void setSunid(Integer sunid) {
        this.sunid = sunid;
    }

    public int getClassId() {
        return this.classId;
    }

    public void setClassId(int classId) {
        this.classId = classId;
    }

    public int getFoldId() {
        return this.foldId;
    }

    public void setFoldId(int foldId) {
        this.foldId = foldId;
    }

    public int getSuperfamilyId() {
        return this.superfamilyId;
    }

    public void setSuperfamilyId(int superfamilyId) {
        this.superfamilyId = superfamilyId;
    }

    public int getFamilyId() {
        return this.familyId;
    }

    public void setFamilyId(int familyId) {
        this.familyId = familyId;
    }

    public int getDomainId() {
        return this.domainId;
    }

    public void setDomainId(int domainId) {
        this.domainId = domainId;
    }

    public int getSpeciesId() {
        return this.speciesId;
    }

    public void setSpeciesId(int speciesId) {
        this.speciesId = speciesId;
    }

    public int getPx() {
        return this.px;
    }

    public void setPx(int px) {
        this.px = px;
    }

    protected Object clone() throws CloneNotSupportedException {
        super.clone();
        ScopDomain n = new ScopDomain();
        n.setClassId(this.getClassId());
        n.setClassificationId(this.getClassificationId());
        n.setDomainId(this.getDomainId());
        n.setFamilyId(this.getFamilyId());
        n.setFoldId(this.getFoldId());
        n.setPdbId(this.getPdbId());
        n.setPx(this.getPx());
        n.setRanges(this.getRanges());
        n.setScopId(this.getScopId());
        n.setSpeciesId(this.getSpeciesId());
        n.setSunid(this.getSunid());
        n.setSuperfamilyId(this.getSuperfamilyId());
        return n;
    }

    public Set<String> getChains() {
        HashSet<String> chains = new HashSet<String>();
        List<ResidueRange> rrs = ResidueRange.parseMultiple(this.getRanges());
        for (ResidueRange rr : rrs) {
            chains.add(rr.getChainId());
        }
        return chains;
    }

    @Override
    public String getIdentifier() {
        return this.getScopId();
    }

    public List<ResidueRange> getResidueRanges() {
        return ResidueRange.parseMultiple(this.ranges);
    }

    @Override
    public SubstructureIdentifier toCanonical() {
        return new SubstructureIdentifier(this.getPdbId(), ResidueRange.parseMultiple(this.getRanges()));
    }

    @Override
    public Structure reduce(Structure input) throws StructureException {
        return this.toCanonical().reduce(input);
    }

    @Override
    public Structure loadStructure(AtomCache cache) throws StructureException, IOException {
        return cache.getStructureForPdbId(this.pdbId);
    }
}

