/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Group;

public class UniqueSequenceList
implements Cloneable {
    private String sequenceString = "";
    private String seqResSequence = "";
    private List<Integer> alignment1 = null;
    private List<Integer> alignment2 = null;
    private Atom[] caAtoms = null;
    private String chainId = null;
    private int modelNumber = -1;
    private int structureId = -1;

    public UniqueSequenceList(Atom[] cAlphaAtoms, String chainId, int modelNumber, int structureId, String seqResSequence) {
        this.caAtoms = cAlphaAtoms;
        this.chainId = chainId;
        this.modelNumber = modelNumber;
        this.structureId = structureId;
        this.seqResSequence = seqResSequence;
        this.sequenceString = UniqueSequenceList.getSequenceString(cAlphaAtoms);
        this.alignment1 = new ArrayList<Integer>(cAlphaAtoms.length);
        this.alignment2 = new ArrayList<Integer>(cAlphaAtoms.length);
        for (int i = 0; i < cAlphaAtoms.length; ++i) {
            this.alignment1.add(i);
            this.alignment2.add(i);
        }
    }

    public boolean isMatch(Atom[] caAlphaAtoms) {
        return this.sequenceString.equals(UniqueSequenceList.getSequenceString(caAlphaAtoms));
    }

    public String getChainId() {
        return this.chainId;
    }

    public int getModelNumber() {
        return this.modelNumber;
    }

    public int getStructureId() {
        return this.structureId;
    }

    public Atom[] getCalphaAtoms() {
        return this.caAtoms;
    }

    public String getSeqResSequence() {
        return this.seqResSequence;
    }

    public void setSequenceString(String sequenceString) {
        this.sequenceString = sequenceString;
    }

    public List<Integer> getAlignment1() {
        return this.alignment1;
    }

    public void setAlignment1(List<Integer> alignment1) {
        this.alignment1 = alignment1;
    }

    public List<Integer> getAlignment2() {
        return this.alignment2;
    }

    public void setAlignment2(List<Integer> alignment2) {
        this.alignment2 = alignment2;
    }

    public Object clone() {
        UniqueSequenceList copy = null;
        try {
            copy = (UniqueSequenceList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        copy.alignment1 = new ArrayList<Integer>(this.alignment1);
        copy.alignment2 = new ArrayList<Integer>(this.alignment2);
        copy.caAtoms = Arrays.copyOf(this.caAtoms, this.caAtoms.length);
        return copy;
    }

    public static String getSequenceString(Atom[] caAlphaAtoms) {
        StringBuilder builder = new StringBuilder();
        for (Atom a : caAlphaAtoms) {
            Group g = a.getGroup();
            if (g.getPDBName().equals("UNK")) continue;
            builder.append(g.getResidueNumber());
            builder.append(g.getPDBName());
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("length: ");
        builder.append(this.caAtoms.length);
        builder.append(" seq: ");
        builder.append(this.sequenceString);
        builder.append("\n");
        builder.append(this.alignment1);
        builder.append("\n");
        builder.append(this.alignment2);
        return builder.toString();
    }
}

