/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.biojava.nbio.structure.align.pairwise.AlternativeAlignment;

public class ClusterAltAligs {
    public static final int DEFAULT_CLUSTER_CUTOFF = 95;

    public static void cluster(AlternativeAlignment[] aligs) {
        ClusterAltAligs.cluster(aligs, 95);
    }

    public static void cluster(AlternativeAlignment[] aligs, int cutoff) {
        List<AlternativeAlignment> alist = Arrays.asList(aligs);
        ArrayList<AlternativeAlignment> testAligs = new ArrayList<AlternativeAlignment>(alist);
        ArrayList clusters = new ArrayList();
        ArrayList<AlternativeAlignment> excludeList = new ArrayList<AlternativeAlignment>();
        for (int i = 0; i < aligs.length; ++i) {
            AlternativeAlignment a = aligs[i];
            if (excludeList.contains(a)) continue;
            int[] idxA = a.getIdx1();
            Iterator iter = testAligs.iterator();
            ArrayList<AlternativeAlignment> remainList = new ArrayList<AlternativeAlignment>();
            ArrayList<Integer> currentCluster = new ArrayList<Integer>();
            currentCluster.add(new Integer(i));
            excludeList.add(a);
            int j = -1;
            while (iter.hasNext()) {
                ++j;
                AlternativeAlignment b = (AlternativeAlignment)iter.next();
                if (excludeList.contains(b)) continue;
                int[] idxB = b.getIdx1();
                int samepos = 0;
                for (int x = 0; x < idxA.length; ++x) {
                    int p1 = idxA[x];
                    for (int y = 0; y < idxB.length; ++y) {
                        int p2 = idxB[y];
                        if (p1 != p2) continue;
                        ++samepos;
                    }
                }
                float perpos = (float)samepos / (float)idxA.length * 100.0f;
                if (perpos > (float)cutoff) {
                    currentCluster.add(new Integer(j));
                    excludeList.add(b);
                    continue;
                }
                remainList.add(b);
            }
            clusters.add(currentCluster);
            if (remainList.size() == 0) break;
        }
        Iterator iter = clusters.iterator();
        int cpos = 0;
        while (iter.hasNext()) {
            ++cpos;
            List cluster = (List)iter.next();
            for (Integer i : cluster) {
                AlternativeAlignment alig = aligs[i];
                alig.setCluster(cpos);
            }
        }
    }
}

