/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.domain;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.client.JFatCatClient;
import org.biojava.nbio.structure.align.client.StructureName;
import org.biojava.nbio.structure.align.util.HTTPConnectionTools;
import org.biojava.nbio.structure.domain.AssignmentXMLSerializer;
import org.biojava.nbio.structure.domain.DomainProvider;
import org.biojava.nbio.structure.domain.PDPProvider;
import org.biojava.nbio.structure.domain.RemotePDPProvider;
import org.biojava.nbio.structure.domain.SerializableCache;
import org.biojava.nbio.structure.scop.ScopDatabase;
import org.biojava.nbio.structure.scop.ScopDomain;
import org.biojava.nbio.structure.scop.ScopFactory;
import org.biojava.nbio.structure.scop.server.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDomainProvider
extends SerializableCache<String, SortedSet<String>>
implements DomainProvider {
    private static final Logger logger = LoggerFactory.getLogger(RemoteDomainProvider.class);
    public String url = "http://source.rcsb.org/jfatcatserver/domains/";
    ScopDatabase scop;
    PDPProvider pdp;
    private static String CACHE_FILE_NAME = "remotedomaincache.ser";

    public RemoteDomainProvider() {
        super(CACHE_FILE_NAME);
        this.disableCache();
        this.scop = ScopFactory.getSCOP();
        this.pdp = new RemotePDPProvider();
    }

    public RemoteDomainProvider(boolean cache) throws IOException {
        super(CACHE_FILE_NAME);
        if (!cache) {
            this.disableCache();
        } else {
            this.loadRepresentativeDomainAssignments();
        }
        this.scop = ScopFactory.getSCOP();
        this.pdp = new RemotePDPProvider(cache);
    }

    private void loadRepresentativeDomainAssignments() throws IOException {
        AssignmentXMLSerializer results = null;
        try {
            URL u = new URL(this.url + "getRepresentativeDomains");
            logger.info("Fetching {}", (Object)u);
            InputStream response = HTTPConnectionTools.getInputStream(u);
            String xml = JFatCatClient.convertStreamToString(response);
            results = AssignmentXMLSerializer.fromXML(xml);
            Map<String, String> data = results.getAssignments();
            logger.info("got {} ranges from server.", (Object)data.size());
            for (String key : data.keySet()) {
                String range = data.get(key);
                String[] spl = range.split(",");
                TreeSet<String> value = new TreeSet<String>();
                for (String s : spl) {
                    value.add(s);
                }
                this.serializedCache.put(key, value);
            }
        }
        catch (MalformedURLException e) {
            logger.error("Malformed Domain server: " + this.url, (Throwable)e);
            throw new IllegalArgumentException("Invalid Server: " + this.url, e);
        }
    }

    @Override
    public SortedSet<String> getDomainNames(String name) throws IOException, StructureException {
        if (name.length() < 4) {
            throw new IllegalArgumentException("Can't interpret IDs that are shorter than 4 residues!");
        }
        if (this.serializedCache != null && this.serializedCache.containsKey(name)) {
            return (SortedSet)this.serializedCache.get(name);
        }
        StructureName n = new StructureName(name);
        List<ScopDomain> scopDomains = this.scop.getDomainsForPDB(n.getPdbId());
        String chainID = n.getChainId();
        if (scopDomains == null || scopDomains.size() == 0) {
            SortedSet<String> data = this.getPDPDomains(n);
            this.cache(name, data);
            return data;
        }
        TreeSet<String> r = new TreeSet<String>();
        for (ScopDomain d : scopDomains) {
            StructureName s = new StructureName(d.getScopId());
            if (chainID == null) {
                r.add(s.getIdentifier());
                continue;
            }
            if (!s.getChainId().equalsIgnoreCase(n.getChainId())) continue;
            r.add(s.getIdentifier());
        }
        this.cache(name, r);
        return r;
    }

    private SortedSet<String> getPDPDomains(StructureName n) throws IOException, StructureException {
        SortedSet<String> pdpDomains = this.pdp.getPDPDomainNamesForPDB(n.getPdbId());
        TreeSet<String> r = new TreeSet<String>();
        String chainID = n.getChainId();
        for (String s : pdpDomains) {
            StructureName d = new StructureName(s);
            if (chainID == null) {
                r.add(s);
                continue;
            }
            if (!d.getChainId().equals(n.getChainId())) continue;
            r.add(s);
        }
        logger.info(n + " got PDP domains: " + r);
        return r;
    }

    public static void main(String[] args) throws IOException, StructureException {
        String name = "3KIH.A";
        RemoteDomainProvider me = new RemoteDomainProvider(true);
        System.out.println(me.getDomainNames(name));
        StructureName n = new StructureName(name);
        System.out.println(n);
        me.flushCache();
    }

    @Override
    public void flushCache() {
        super.flushCache();
        if (this.pdp instanceof RemotePDPProvider) {
            RemotePDPProvider remotePDP = (RemotePDPProvider)this.pdp;
            remotePDP.flushCache();
        }
    }

    @Override
    public SortedSet<String> getRepresentativeDomains() throws IOException {
        String url = "http://source.rcsb.org/jfatcatserver/domains/getRepresentativeDomainNames";
        SortedSet<String> domainRanges = null;
        try {
            URL u = new URL(url);
            logger.info("Fetching {}", (Object)url);
            InputStream response = HTTPConnectionTools.getInputStream(u);
            String xml = JFatCatClient.convertStreamToString(response);
            domainRanges = XMLUtil.getDomainRangesFromXML(xml);
        }
        catch (MalformedURLException e) {
            logger.error("Malformed Domain server: " + url, (Throwable)e);
            throw new IllegalArgumentException("Invalid Server: " + url, e);
        }
        return domainRanges;
    }
}

