/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.quaternary.io;

import org.biojava.nbio.structure.quaternary.io.BioUnitDataProvider;
import org.biojava.nbio.structure.quaternary.io.MmCifBiolAssemblyProvider;
import org.biojava.nbio.structure.quaternary.io.PDBBioUnitDataProvider;
import org.biojava.nbio.structure.quaternary.io.RemoteBioUnitDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioUnitDataProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(BioUnitDataProviderFactory.class);
    public static final String mmcifProviderClassName = MmCifBiolAssemblyProvider.class.getName();
    public static final String remoteProviderClassName = RemoteBioUnitDataProvider.class.getName();
    public static final String pdbProviderClassName = PDBBioUnitDataProvider.class.getName();
    public static Class<? extends BioUnitDataProvider> DEFAULT_PROVIDER_CLASS = MmCifBiolAssemblyProvider.class;
    public static final String DEFAULT_PROVIDER_CLASSNAME = DEFAULT_PROVIDER_CLASS.getName();
    private static Class<? extends BioUnitDataProvider> providerClass = DEFAULT_PROVIDER_CLASS;

    private BioUnitDataProviderFactory() {
    }

    public static BioUnitDataProvider getBioUnitDataProvider() {
        try {
            return providerClass.newInstance();
        }
        catch (IllegalAccessException e) {
            logger.error("Exception caught", (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error("Exception caught", (Throwable)e);
        }
        return null;
    }

    public static void setBioUnitDataProvider(Class<? extends BioUnitDataProvider> klass) {
        providerClass = klass;
    }

    public static void setBioUnitDataProvider(String className) throws ClassNotFoundException, ClassCastException {
        Class<?> cls = Class.forName(className);
        Class<BioUnitDataProvider> interfaceClass = BioUnitDataProvider.class;
        Class<BioUnitDataProvider> castClass = cls.asSubclass(interfaceClass);
        BioUnitDataProviderFactory.setBioUnitDataProvider(castClass);
    }

    public static Class<? extends BioUnitDataProvider> getBioUnitDataProviderClass() {
        return providerClass;
    }
}

