/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.vecmath.Point3d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.symmetry.core.SequenceAlignmentCluster;

public class ChainClusterer {
    private List<SequenceAlignmentCluster> seqClusters = new ArrayList<SequenceAlignmentCluster>();
    private boolean modified = true;
    private List<Atom[]> caAligned = new ArrayList<Atom[]>();
    private List<Point3d[]> caCoords = new ArrayList<Point3d[]>();

    public ChainClusterer(List<SequenceAlignmentCluster> seqClusters) {
        this.seqClusters = seqClusters;
        this.modified = true;
    }

    public List<Point3d[]> getCalphaCoordinates() {
        this.run();
        return this.caCoords;
    }

    public List<Atom[]> getCalphaTraces() {
        this.run();
        return this.caAligned;
    }

    public List<String> getChainIds() {
        this.run();
        ArrayList<String> chainIdList = new ArrayList<String>();
        for (int i = 0; i < this.seqClusters.size(); ++i) {
            SequenceAlignmentCluster cluster = this.seqClusters.get(i);
            for (String chainId : cluster.getChainIds()) {
                chainIdList.add(chainId);
            }
        }
        return chainIdList;
    }

    public List<Integer> getModelNumbers() {
        this.run();
        ArrayList<Integer> modNumbers = new ArrayList<Integer>();
        for (int i = 0; i < this.seqClusters.size(); ++i) {
            SequenceAlignmentCluster cluster = this.seqClusters.get(i);
            for (Integer number : cluster.getModelNumbers()) {
                modNumbers.add(number);
            }
        }
        return modNumbers;
    }

    public String getStoichiometry() {
        this.run();
        StringBuilder formula = new StringBuilder();
        String alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        for (int i = 0; i < this.seqClusters.size(); ++i) {
            String c = "?";
            if (i < alpha.length()) {
                c = alpha.substring(i, i + 1);
            }
            formula.append(c);
            int multiplier = this.seqClusters.get(i).getSequenceCount();
            if (multiplier <= 1) continue;
            formula.append(multiplier);
        }
        return formula.toString();
    }

    public List<Integer> getFolds() {
        this.run();
        ArrayList<Integer> stoichiometry = new ArrayList<Integer>(this.seqClusters.size());
        for (int id = 0; id < this.seqClusters.size(); ++id) {
            int seqCount = this.seqClusters.get(id).getSequenceCount();
            stoichiometry.add(seqCount);
        }
        return ChainClusterer.getValidFolds(stoichiometry);
    }

    public static List<Integer> getValidFolds(List<Integer> stoichiometry) {
        ArrayList<Integer> denominators = new ArrayList<Integer>();
        int nChains = Collections.max(stoichiometry);
        TreeSet<Integer> nominators = new TreeSet<Integer>(stoichiometry);
        for (int d = 1; d <= nChains; ++d) {
            boolean isDivisable = true;
            for (Integer n : nominators) {
                if (n % d == 0) continue;
                isDivisable = false;
                break;
            }
            if (!isDivisable) continue;
            denominators.add(d);
        }
        return denominators;
    }

    public List<Integer> getSequenceClusterIds() {
        this.run();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int id = 0; id < this.seqClusters.size(); ++id) {
            int seqCount = this.seqClusters.get(id).getSequenceCount();
            for (int i = 0; i < seqCount; ++i) {
                list.add(id);
            }
        }
        return list;
    }

    public int getSequenceClusterCount() {
        this.run();
        return this.seqClusters.size();
    }

    public List<SequenceAlignmentCluster> getSequenceAlignmentClusters() {
        return this.seqClusters;
    }

    public List<Boolean> getPseudoStoichiometry() {
        this.run();
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (int id = 0; id < this.seqClusters.size(); ++id) {
            int seqCount = this.seqClusters.get(id).getSequenceCount();
            Boolean pseudo = this.seqClusters.get(id).isPseudoStoichiometric();
            for (int i = 0; i < seqCount; ++i) {
                list.add(pseudo);
            }
        }
        return list;
    }

    public List<Double> getMinSequenceIdentity() {
        this.run();
        ArrayList<Double> list = new ArrayList<Double>();
        for (int id = 0; id < this.seqClusters.size(); ++id) {
            int seqCount = this.seqClusters.get(id).getSequenceCount();
            double minSequenceIdentity = this.seqClusters.get(id).getMinSequenceIdentity();
            for (int i = 0; i < seqCount; ++i) {
                list.add(minSequenceIdentity);
            }
        }
        return list;
    }

    public List<Double> getMaxSequenceIdentity() {
        this.run();
        ArrayList<Double> list = new ArrayList<Double>();
        for (int id = 0; id < this.seqClusters.size(); ++id) {
            int seqCount = this.seqClusters.get(id).getSequenceCount();
            double maxSequenceIdentity = this.seqClusters.get(id).getMaxSequenceIdentity();
            for (int i = 0; i < seqCount; ++i) {
                list.add(maxSequenceIdentity);
            }
        }
        return list;
    }

    public String toString() {
        this.run();
        StringBuilder builder = new StringBuilder();
        builder.append("Sequence alignment clusters: " + this.seqClusters.size());
        builder.append("\n");
        for (SequenceAlignmentCluster s : this.seqClusters) {
            builder.append("# seq: ");
            builder.append(s.getSequenceCount());
            builder.append(" alignment length: ");
            builder.append(s.getSequenceAlignmentLength());
            builder.append("\n");
        }
        return builder.toString();
    }

    private void run() {
        if (this.modified) {
            this.modified = false;
            this.calcAlignedSequences();
            this.createCalphaTraces();
        }
    }

    private void calcAlignedSequences() {
        this.caAligned = new ArrayList<Atom[]>();
        for (SequenceAlignmentCluster cluster : this.seqClusters) {
            this.caAligned.addAll(cluster.getAlignedCalphaAtoms());
        }
    }

    private void createCalphaTraces() {
        for (Atom[] atoms : this.caAligned) {
            Point3d[] trace = new Point3d[atoms.length];
            for (int j = 0; j < atoms.length; ++j) {
                trace[j] = new Point3d(atoms[j].getCoords());
            }
            this.caCoords.add(trace);
        }
    }
}

