/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.Collections;
import java.util.List;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.symmetry.core.ClusterMerger;
import org.biojava.nbio.structure.symmetry.core.ProteinSequenceClusterer;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryParameters;
import org.biojava.nbio.structure.symmetry.core.SequenceAlignmentCluster;

public class ClusterProteinChains {
    private Structure structure = null;
    private Structure structure2 = null;
    private QuatSymmetryParameters parameters = null;
    private ClusterMerger merger = null;
    private int proteinChainCount = 0;
    private int nucleicAcidChainCount = 0;

    public ClusterProteinChains(Structure structure, QuatSymmetryParameters parameters) {
        this.structure = structure;
        this.parameters = parameters;
        this.run();
    }

    public ClusterProteinChains(Structure structure1, Structure structure2, QuatSymmetryParameters parameters) {
        this.structure = structure1;
        this.structure2 = structure2;
        this.parameters = parameters;
        this.run();
    }

    public List<SequenceAlignmentCluster> getSequenceAlignmentClusters(double sequenceIdentityThreshold) {
        if (this.merger == null) {
            return Collections.emptyList();
        }
        return this.merger.getMergedClusters(sequenceIdentityThreshold);
    }

    public int getProteinChainCount() {
        return this.proteinChainCount;
    }

    public int getNucleicAcidChainCount() {
        return this.nucleicAcidChainCount;
    }

    private void run() {
        List<SequenceAlignmentCluster> seqClusters = null;
        if (this.structure2 == null) {
            ProteinSequenceClusterer clusterer = new ProteinSequenceClusterer(this.structure, this.parameters);
            seqClusters = clusterer.getSequenceAlignmentClusters();
            this.proteinChainCount = clusterer.getProteinChainCount();
            this.nucleicAcidChainCount = clusterer.getNucleicAcidChainCount();
        } else if (this.structure != null && this.structure2 != null) {
            ProteinSequenceClusterer clusterer = new ProteinSequenceClusterer(this.structure, this.structure2, this.parameters);
            seqClusters = clusterer.getSequenceAlignmentClusters();
        }
        if (seqClusters == null || seqClusters.size() == 0) {
            return;
        }
        this.merger = new ClusterMerger(seqClusters, this.parameters);
        this.merger.calcPairwiseAlignments();
    }
}

