/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.xtal;

import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.contact.BoundingBox;

public class UnitCellBoundingBox {
    private BoundingBox[][] chainBbs;
    private BoundingBox[] auBbs;
    private int numOperatorsSg;
    private int numChainsAu;

    public UnitCellBoundingBox(int numOperatorsSg, int numChainsAu) {
        this.numOperatorsSg = numOperatorsSg;
        this.numChainsAu = numChainsAu;
        this.chainBbs = new BoundingBox[numOperatorsSg][numChainsAu];
        this.auBbs = new BoundingBox[numOperatorsSg];
    }

    public void setBbs(Structure structure, Matrix4d[] ops, boolean includeHetAtoms) {
        this.setBb(structure, includeHetAtoms, 0);
        for (int i = 1; i < ops.length; ++i) {
            Structure sym = structure.clone();
            Calc.transform(sym, ops[i]);
            this.setBb(sym, includeHetAtoms, i);
        }
    }

    private void setBb(Structure s, boolean includeHetAtoms, int i) {
        this.chainBbs[i] = new BoundingBox[this.numChainsAu];
        for (int j = 0; j < this.numChainsAu; ++j) {
            this.chainBbs[i][j] = new BoundingBox(StructureTools.getAllNonHAtomArray(s.getChain(j), includeHetAtoms));
        }
        this.auBbs[i] = new BoundingBox(this.chainBbs[i]);
    }

    public BoundingBox getChainBoundingBox(int cellIdx, int chainIdx) {
        return this.chainBbs[cellIdx][chainIdx];
    }

    public BoundingBox getAuBoundingBox(int cellIdx) {
        return this.auBbs[cellIdx];
    }

    public UnitCellBoundingBox getTranslatedBbs(Vector3d translation) {
        UnitCellBoundingBox translatedBbs = new UnitCellBoundingBox(this.numOperatorsSg, this.numChainsAu);
        for (int i = 0; i < this.numOperatorsSg; ++i) {
            for (int j = 0; j < this.numChainsAu; ++j) {
                translatedBbs.chainBbs[i][j] = new BoundingBox(this.chainBbs[i][j]);
                translatedBbs.chainBbs[i][j].translate(translation);
            }
            translatedBbs.auBbs[i] = new BoundingBox(translatedBbs.chainBbs[i]);
        }
        return translatedBbs;
    }
}

