/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.nbio.structure.AtomPositionMap;
import org.biojava.nbio.structure.ResidueNumber;

public class ResidueRange {
    private final String chainName;
    private final ResidueNumber end;
    private final ResidueNumber start;
    public static final Pattern RANGE_REGEX = Pattern.compile("^\\s*([a-zA-Z0-9]+|_)(?:(?::|_|:$|_$|$)(?:([-+]?[0-9]+[A-Za-z]?|\\^)?(?:\\s*(-)\\s*([-+]?[0-9]+[A-Za-z]?|\\$)?)?+)?+)?\\s*");
    public static final Pattern CHAIN_REGEX = Pattern.compile("^\\s*([a-zA-Z0-9]+|_)$");

    public static ResidueRange parse(String s) {
        Matcher matcher = RANGE_REGEX.matcher(s);
        if (matcher.matches()) {
            ResidueNumber start = null;
            ResidueNumber end = null;
            String chain = null;
            try {
                chain = matcher.group(1);
                if (matcher.group(2) != null && !"^".equals(matcher.group(2))) {
                    start = ResidueNumber.fromString(matcher.group(2));
                    start.setChainName(chain);
                }
                if (matcher.group(3) == null) {
                    end = start;
                } else if (matcher.group(4) != null && !"$".equals(matcher.group(4))) {
                    end = ResidueNumber.fromString(matcher.group(4));
                    end.setChainName(chain);
                }
                return new ResidueRange(chain, start, end);
            }
            catch (IllegalStateException e) {
                throw new IllegalArgumentException("Range " + s + " was not valid", e);
            }
        }
        if (CHAIN_REGEX.matcher(s).matches()) {
            return new ResidueRange(s, (ResidueNumber)null, null);
        }
        throw new IllegalArgumentException("Illegal ResidueRange format:" + s);
    }

    public static List<ResidueRange> parseMultiple(String s) {
        if ((s = s.trim()).startsWith("(")) {
            s = s.substring(1);
        }
        if (s.endsWith(")")) {
            s = s.substring(0, s.length() - 1);
        }
        String[] parts = s.split(",");
        ArrayList<ResidueRange> list = new ArrayList<ResidueRange>(parts.length);
        for (String part : parts) {
            list.add(ResidueRange.parse(part));
        }
        return list;
    }

    public ResidueRange(String chainName, String start, String end) {
        this.chainName = chainName;
        this.start = ResidueNumber.fromString(start);
        this.start.setChainName(chainName);
        this.end = ResidueNumber.fromString(end);
        this.end.setChainName(chainName);
    }

    public ResidueRange(String chainName, ResidueNumber start, ResidueNumber end) {
        this.chainName = chainName;
        this.start = start;
        this.end = end;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResidueRange other = (ResidueRange)obj;
        if (this.chainName == null ? other.chainName != null : !this.chainName.equals(other.chainName)) {
            return false;
        }
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        return !(this.start == null ? other.start != null : !this.start.equals(other.start));
    }

    public String getChainName() {
        return this.chainName;
    }

    public ResidueNumber getEnd() {
        return this.end;
    }

    public ResidueNumber getStart() {
        return this.start;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.chainName == null ? 0 : this.chainName.hashCode());
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        return result;
    }

    public String toString() {
        if (this.start == null && this.end == null) {
            return this.chainName;
        }
        return this.chainName + "_" + this.start + "-" + this.end;
    }

    public ResidueNumber getResidue(int positionInRange, AtomPositionMap map) {
        if (map == null) {
            throw new NullPointerException("The AtomPositionMap must be non-null");
        }
        int i = 0;
        for (Map.Entry entry : map.getNavMap().entrySet()) {
            if (i == positionInRange) {
                return (ResidueNumber)entry.getKey();
            }
            if (!this.contains((ResidueNumber)entry.getKey(), map)) continue;
            ++i;
        }
        return null;
    }

    public boolean contains(ResidueNumber residueNumber, AtomPositionMap map) {
        if (residueNumber == null) {
            throw new NullPointerException("Can't find the ResidueNumber because it is null");
        }
        if (map == null) {
            throw new NullPointerException("The AtomPositionMap must be non-null");
        }
        Integer pos = map.getPosition(residueNumber);
        if (pos == null) {
            throw new IllegalArgumentException("Couldn't find residue " + residueNumber.printFull());
        }
        ResidueNumber startResidue = this.getStart() == null ? map.getFirst(this.getChainName()) : this.getStart();
        Integer startPos = map.getPosition(startResidue);
        if (startPos == null) {
            throw new IllegalArgumentException("Couldn't find the start position");
        }
        ResidueNumber endResidue = this.getEnd() == null ? map.getLast(this.getChainName()) : this.getEnd();
        Integer endPos = map.getPosition(endResidue);
        if (endPos == null) {
            throw new IllegalArgumentException("Couldn't find the end position");
        }
        return pos >= startPos && pos <= endPos;
    }

    public Iterator<ResidueNumber> iterator(final AtomPositionMap map) {
        final Iterator entryIt = map.getNavMap().entrySet().iterator();
        if (!entryIt.hasNext()) {
            return Arrays.asList(new ResidueNumber[0]).iterator();
        }
        return new Iterator<ResidueNumber>(){
            Map.Entry<ResidueNumber, Integer> next = this.loadNext();

            private Map.Entry<ResidueNumber, Integer> loadNext() {
                while (entryIt.hasNext()) {
                    this.next = (Map.Entry)entryIt.next();
                    ResidueNumber nextPos = this.next.getKey();
                    if (!ResidueRange.this.contains(nextPos, map)) continue;
                    return this.next;
                }
                this.next = null;
                return this.next;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public ResidueNumber next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ResidueNumber pos = this.next.getKey();
                this.loadNext();
                return pos;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not modifiable");
            }
        };
    }

    public static Iterator<ResidueNumber> multiIterator(final AtomPositionMap map, final ResidueRange ... rrs) {
        return new Iterator<ResidueNumber>(){
            private int r = 0;
            private Iterator<ResidueNumber> internal;

            @Override
            public boolean hasNext() {
                if (this.r == rrs.length - 1) {
                    this.init();
                    return this.internal.hasNext();
                }
                return true;
            }

            private void init() {
                if (this.internal == null) {
                    this.internal = rrs[this.r].iterator(map);
                }
            }

            @Override
            public ResidueNumber next() {
                if (rrs.length == 0) {
                    throw new NoSuchElementException();
                }
                this.init();
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (!this.internal.hasNext()) {
                    ++this.r;
                    this.internal = rrs[this.r].iterator(map);
                }
                return this.internal.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not modifiable");
            }
        };
    }

    public static Iterator<ResidueNumber> multiIterator(AtomPositionMap map, List<? extends ResidueRange> rrs) {
        ResidueRange[] ranges = new ResidueRange[rrs.size()];
        for (int i = 0; i < rrs.size(); ++i) {
            ranges[i] = rrs.get(i);
        }
        return ResidueRange.multiIterator(map, ranges);
    }

    public static List<ResidueRange> parseMultiple(List<String> ranges) {
        ArrayList<ResidueRange> rrs = new ArrayList<ResidueRange>(ranges.size());
        for (String range : ranges) {
            ResidueRange rr = ResidueRange.parse(range);
            if (rr == null) continue;
            rrs.add(rr);
        }
        return rrs;
    }

    public static List<String> toStrings(List<? extends ResidueRange> ranges) {
        ArrayList<String> list = new ArrayList<String>(ranges.size());
        for (ResidueRange residueRange : ranges) {
            list.add(residueRange.toString());
        }
        return list;
    }

    public static String toString(List<? extends ResidueRange> ranges) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ranges.size(); ++i) {
            sb.append(ranges.get(i));
            if (i >= ranges.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

