/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.client.FarmJobParameters;
import org.biojava.nbio.structure.align.client.JobKillException;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.align.util.ResourceManager;
import org.biojava.nbio.structure.align.util.URLConnectionTools;
import org.biojava.nbio.structure.align.xml.AFPChainXMLConverter;
import org.biojava.nbio.structure.align.xml.AFPChainXMLParser;
import org.biojava.nbio.structure.align.xml.HasResultXMLConverter;
import org.biojava.nbio.structure.align.xml.PdbPairXMLConverter;
import org.biojava.nbio.structure.align.xml.PdbPairsMessage;
import org.biojava.nbio.structure.align.xml.PositionInQueueXMLConverter;
import org.biojava.nbio.structure.align.xml.RepresentativeXMLConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JFatCatClient {
    private static final Logger logger = LoggerFactory.getLogger(JFatCatClient.class);
    private static ResourceManager resourceManager = ResourceManager.getResourceManager("jfatcat");
    private static final String serverAPPEND = "show?name1=%s&name2=%s";
    private static final String sendAPPEND = "submit?name1=%s&name2=%s&version=%s";
    private static final String multiSendAPPEND = "jobSubmit?username=%s&version=%s";
    private static final String representAPPEND = "representatives?cluster=%s";
    private static final String serverHasResult = "hasResult?method=%s&name1=%s&name2=%s";
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final String serverPositionInQueue = "queuePosition?method=%s&name1=%s&name2=%s";
    private static Random generator;
    private static String newline;
    private static String KILL_JOB;
    private static String COME_BACK_LATER;

    public static void main(String[] args) throws Exception {
        AtomCache cache = new AtomCache();
        String name1 = "2W72.A";
        String name2 = "1D2Z.D";
        Atom[] ca1 = cache.getAtoms(name1);
        Atom[] ca2 = cache.getAtoms(name2);
        int timeout = 10000;
        String testServer = "http://source.rcsb.org/jfatcatserver/align/";
        System.out.println(JFatCatClient.getAFPChainFromServer(testServer, "jFatCat_rigid", name1, name2, ca1, ca2, timeout));
        PdbPairsMessage msg = JFatCatClient.getPdbPairs(testServer, 1, "test");
        System.out.println(msg);
        System.out.println(JFatCatClient.getRepresentatives(FarmJobParameters.DEFAULT_SERVER_URL, 40));
    }

    public static boolean hasPrecalculatedResult(String serverLocation, String method, String name1, String name2) {
        return JFatCatClient.hasPrecalculatedResult(serverLocation, method, name1, name2, 5000);
    }

    public static boolean hasPrecalculatedResult(String serverLocation, String method, String name1, String name2, int timeout) {
        String serverURL = serverLocation + serverHasResult;
        boolean hasResults = false;
        try {
            String u = String.format(serverURL, URLEncoder.encode(method, "UTF-8"), name1, name2);
            URL url = new URL(u);
            InputStream stream = URLConnectionTools.getInputStream(url, timeout);
            String xml = null;
            if (stream != null) {
                xml = JFatCatClient.convertStreamToString(stream);
                logger.info(" has PrecalcResults got XML from server: " + xml);
                HasResultXMLConverter conv = new HasResultXMLConverter();
                hasResults = conv.fromXML(xml);
            }
        }
        catch (IOException e) {
            logger.error("error in JFatCatClient: getAFPChainFromServer", (Throwable)e);
        }
        return hasResults;
    }

    public int getPositionInQueue(String serverLocation, String method, String name1, String name2) {
        return this.getPositionInQueue(serverLocation, method, name1, name2, 5000);
    }

    public int getPositionInQueue(String serverLocation, String method, String name1, String name2, int timeout) {
        String serverURL = serverLocation + serverPositionInQueue;
        int position = Integer.MIN_VALUE;
        try {
            String u = String.format(serverURL, URLEncoder.encode(method, "UTF-8"), name1, name2);
            URL url = new URL(u);
            InputStream stream = URLConnectionTools.getInputStream(url, timeout);
            String xml = null;
            if (stream != null) {
                xml = JFatCatClient.convertStreamToString(stream);
                PositionInQueueXMLConverter conv = new PositionInQueueXMLConverter();
                position = conv.fromXML(xml);
            }
        }
        catch (IOException e) {
            logger.error("error in JFatCatClient: getAFPChainFromServer", (Throwable)e);
        }
        return position;
    }

    public static AFPChain getAFPChainFromServer(String serverLocation, String name1, String name2, Atom[] ca1, Atom[] ca2) {
        String method = "jFatCat_rigid";
        return JFatCatClient.getAFPChainFromServer(serverLocation, method, name1, name2, ca1, ca2, 5000);
    }

    public static AFPChain getAFPChainFromServer(String serverLocation, String method, String name1, String name2, Atom[] ca1, Atom[] ca2, int timeout) {
        String serverURL = serverLocation + serverAPPEND;
        try {
            String u = String.format(serverURL, name1, name2);
            if (method != null) {
                u = u + "&method=" + URLEncoder.encode(method, "UTF-8");
            }
            URL url = new URL(u);
            logger.info("requesting alignment from server..." + url);
            InputStream stream = URLConnectionTools.getInputStream(url, timeout);
            String xml = null;
            if (stream != null) {
                xml = JFatCatClient.convertStreamToString(stream);
            }
            if (xml != null) {
                return AFPChainXMLParser.fromXML(xml, name1, name2, ca1, ca2);
            }
            return null;
        }
        catch (IOException e) {
            logger.error("error in JFatCatClient: getAFPChainFromServer", (Throwable)e);
        }
        catch (StructureException e) {
            logger.error("error in JFatCatClient: getAFPChainFromServer", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream stream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line).append(newline);
            }
        }
        catch (IOException e) {
            logger.error("Couldn't convert stream to string", (Throwable)e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.warn("Can't close stream", (Throwable)e);
            }
        }
        return sb.toString();
    }

    public static String sendMultiAFPChainToServer(String serverLocation, String multiXML, String username) throws JobKillException {
        String version = resourceManager.getString("jfatcat.version");
        return JFatCatClient.sendMultiAFPChainToServer(serverLocation, multiXML, username, version);
    }

    public static String sendMultiAFPChainToServer(String serverLocation, String multiXML, String username, String version) throws JobKillException {
        String multiSendURL = serverLocation + multiSendAPPEND;
        String responseS = "";
        String u = String.format(multiSendURL, username, version);
        int timeout = JFatCatClient.getTimeout();
        boolean submitted = false;
        while (!submitted) {
            try {
                URL url = new URL(u);
                InputStream response = URLConnectionTools.doPOST(url, multiXML, timeout);
                responseS = JFatCatClient.convertStreamToString(response);
                submitted = true;
                if (!responseS.contains("OK")) {
                    logger.error("server returned " + responseS);
                }
                if (!responseS.startsWith(COME_BACK_LATER)) continue;
                submitted = false;
            }
            catch (Exception e) {
                logger.error("Error in JFatCatClient: while sending results back to server", (Throwable)e);
                try {
                    int randomSleep = JFatCatClient.getRandomSleepTime();
                    logger.warn("sleeping " + randomSleep / 1000 + " sec.");
                    Thread.sleep(randomSleep);
                }
                catch (InterruptedException ex) {
                    logger.warn("Interrupted while sleeping", (Throwable)ex);
                }
            }
        }
        if (responseS.startsWith(KILL_JOB)) {
            throw new JobKillException("Server responded with KILL message.");
        }
        return responseS;
    }

    public static int getRandomSleepTime() {
        int minTime = 560000;
        int maxTime = 7800000 - minTime;
        int nextId = generator.nextInt(maxTime);
        return minTime + nextId;
    }

    public static final void sendAFPChainToServer(String serverLocation, AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws JobKillException {
        String sendURL = serverLocation + sendAPPEND;
        String version = resourceManager.getString("jfatcat.version");
        int timeout = JFatCatClient.getTimeout();
        try {
            afpChain.getSimilarity();
            String xml = AFPChainXMLConverter.toXML(afpChain, ca1, ca2);
            String u = String.format(sendURL, afpChain.getName1(), afpChain.getName2(), version);
            URL url = new URL(u);
            InputStream response = URLConnectionTools.doPOST(url, xml, timeout);
            logger.debug("got response: {}", (Object)JFatCatClient.convertStreamToString(response));
            if (xml.startsWith("KILL_JOB")) {
                throw new JobKillException("Server responded with KILL message.");
            }
        }
        catch (IOException e) {
            logger.error("error in JFatCatClient: sendAFPChainToServer", (Throwable)e);
        }
    }

    public static final int getTimeout() {
        String timeoutS = resourceManager.getString("connection.timeout");
        int timeout = 60000;
        try {
            timeout = Integer.parseInt(timeoutS);
        }
        catch (NumberFormatException ex) {
            logger.error("Bad connection.timeout parameter", (Throwable)ex);
        }
        return timeout;
    }

    public static final PdbPairsMessage getPdbPairs(String url, int nrPair, String username) throws IOException, JobKillException {
        String urlS = url + "getPairs?nrPairs=" + nrPair + "&username=" + URLEncoder.encode(username, "UTF-8");
        int timeout = JFatCatClient.getTimeout();
        PdbPairsMessage msg = null;
        logger.info("requesting {}", (Object)urlS);
        URL serverUrl = new URL(urlS);
        InputStream stream = URLConnectionTools.getInputStream(serverUrl, timeout);
        String xml = null;
        if (stream != null && (xml = JFatCatClient.convertStreamToString(stream)) != null) {
            if (xml.startsWith("KILL_JOB")) {
                throw new JobKillException("Server responded with KILL message.");
            }
            msg = PdbPairXMLConverter.convertXMLtoPairs(xml);
        }
        return msg;
    }

    public static final SortedSet<String> getRepresentatives(String serverLocation, int cutoff) {
        SortedSet<String> representatives = new TreeSet<String>();
        String representURL = serverLocation + representAPPEND;
        if (cutoff < 20) {
            cutoff = 40;
        }
        int timeout = JFatCatClient.getTimeout();
        String u = String.format(representURL, cutoff);
        logger.info("Fetching representatives from " + u);
        try {
            URL url = new URL(u);
            InputStream stream = URLConnectionTools.getInputStream(url, timeout);
            String xml = null;
            if (stream != null) {
                xml = JFatCatClient.convertStreamToString(stream);
            }
            if (xml != null) {
                representatives = RepresentativeXMLConverter.fromXML(xml);
            }
        }
        catch (IOException e) {
            logger.error("Error fetching representatives", (Throwable)e);
        }
        return representatives;
    }

    static {
        newline = System.getProperty("line.separator");
        KILL_JOB = "KILL_JOB";
        COME_BACK_LATER = "COME_BACK_LATER";
        generator = new Random();
    }
}

