/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.cluster;

import java.io.Serializable;
import org.biojava.nbio.structure.cluster.SubunitClustererMethod;

public class SubunitClustererParameters
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int minimumSequenceLength = 20;
    private int absoluteMinimumSequenceLength = 5;
    private double minimumSequenceLengthFraction = 0.75;
    private boolean useGlobalMetrics;
    private double sequenceIdentityThreshold;
    private double sequenceCoverageThreshold = 0.75;
    private double rmsdThreshold = 3.0;
    private double structureCoverageThreshold = 0.75;
    private double tmThreshold = 0.5;
    private SubunitClustererMethod clustererMethod = SubunitClustererMethod.SEQUENCE_STRUCTURE;
    private String superpositionAlgorithm = "jCE";
    private boolean optimizeAlignment = true;
    private boolean useSequenceCoverage;
    private boolean useRMSD;
    private boolean useStructureCoverage;
    private boolean useTMScore;
    private boolean internalSymmetry = false;
    private static final double hcSequenceIdentityLocal = 0.95;
    private static final double hcSequenceCoverageLocal = 0.75;
    private static final double hcSequenceIdentityGlobal = 0.85;

    public SubunitClustererParameters(boolean useGlobalMetrics) {
        this.useGlobalMetrics = useGlobalMetrics;
        if (useGlobalMetrics) {
            this.sequenceIdentityThreshold = 0.85;
            this.useSequenceCoverage = false;
            this.useRMSD = false;
            this.useStructureCoverage = false;
            this.useTMScore = true;
        } else {
            this.sequenceIdentityThreshold = 0.95;
            this.useSequenceCoverage = true;
            this.useRMSD = true;
            this.useStructureCoverage = true;
            this.useTMScore = false;
        }
    }

    public SubunitClustererParameters() {
        this(false);
    }

    public int getMinimumSequenceLength() {
        return this.minimumSequenceLength;
    }

    public void setMinimumSequenceLength(int minimumSequenceLength) {
        this.minimumSequenceLength = minimumSequenceLength;
    }

    public int getAbsoluteMinimumSequenceLength() {
        return this.absoluteMinimumSequenceLength;
    }

    public void setAbsoluteMinimumSequenceLength(int absoluteMinimumSequenceLength) {
        this.absoluteMinimumSequenceLength = absoluteMinimumSequenceLength;
    }

    public double getMinimumSequenceLengthFraction() {
        return this.minimumSequenceLengthFraction;
    }

    public void setMinimumSequenceLengthFraction(double minimumSequenceLengthFraction) {
        this.minimumSequenceLengthFraction = minimumSequenceLengthFraction;
    }

    public double getSequenceIdentityThreshold() {
        return this.sequenceIdentityThreshold;
    }

    public void setSequenceIdentityThreshold(double sequenceIdentityThreshold) {
        this.sequenceIdentityThreshold = sequenceIdentityThreshold;
    }

    public double getSequenceCoverageThreshold() {
        return this.sequenceCoverageThreshold;
    }

    public void setSequenceCoverageThreshold(double sequenceCoverageThreshold) {
        this.sequenceCoverageThreshold = sequenceCoverageThreshold;
    }

    public double getRMSDThreshold() {
        return this.rmsdThreshold;
    }

    public void setRMSDThreshold(double rmsdThreshold) {
        this.rmsdThreshold = rmsdThreshold;
    }

    public double getTMThreshold() {
        return this.tmThreshold;
    }

    public void setTMThreshold(double tmThreshold) {
        this.tmThreshold = tmThreshold;
    }

    public double getStructureCoverageThreshold() {
        return this.structureCoverageThreshold;
    }

    public void setStructureCoverageThreshold(double structureCoverageThreshold) {
        this.structureCoverageThreshold = structureCoverageThreshold;
    }

    public SubunitClustererMethod getClustererMethod() {
        return this.clustererMethod;
    }

    public void setClustererMethod(SubunitClustererMethod method) {
        this.clustererMethod = method;
    }

    public boolean isInternalSymmetry() {
        return this.internalSymmetry;
    }

    public void setInternalSymmetry(boolean internalSymmetry) {
        this.internalSymmetry = internalSymmetry;
    }

    public String toString() {
        return "SubunitClustererParameters [minimumSequenceLength=" + this.minimumSequenceLength + ", absoluteMinimumSequenceLength=" + this.absoluteMinimumSequenceLength + ", minimumSequenceLengthFraction=" + this.minimumSequenceLengthFraction + ", sequenceIdentityThreshold=" + this.sequenceIdentityThreshold + ", rmsdThreshold=" + this.rmsdThreshold + ", coverageThreshold=" + this.sequenceCoverageThreshold + ", clustererMethod=" + (Object)((Object)this.clustererMethod) + ", internalSymmetry=" + this.internalSymmetry + "]";
    }

    public String getSuperpositionAlgorithm() {
        return this.superpositionAlgorithm;
    }

    public void setSuperpositionAlgorithm(String superpositionAlgorithm) {
        this.superpositionAlgorithm = superpositionAlgorithm;
    }

    public boolean isOptimizeAlignment() {
        return this.optimizeAlignment;
    }

    public void setOptimizeAlignment(boolean optimizeAlignment) {
        this.optimizeAlignment = optimizeAlignment;
    }

    public boolean isUseRMSD() {
        return this.useRMSD;
    }

    public void setUseRMSD(boolean useRMSD) {
        this.useRMSD = useRMSD;
    }

    public boolean isUseTMScore() {
        return this.useTMScore;
    }

    public void setUseTMScore(boolean useTMScore) {
        this.useTMScore = useTMScore;
    }

    public boolean isUseSequenceCoverage() {
        return this.useSequenceCoverage;
    }

    public void setUseSequenceCoverage(boolean useSequenceCoverage) {
        this.useSequenceCoverage = useSequenceCoverage;
    }

    public boolean isUseStructureCoverage() {
        return this.useStructureCoverage;
    }

    public void setUseStructureCoverage(boolean useStructureCoverage) {
        this.useStructureCoverage = useStructureCoverage;
    }

    public boolean isUseGlobalMetrics() {
        return this.useGlobalMetrics;
    }

    public void setUseGlobalMetrics(boolean useGlobalMetrics) {
        this.useGlobalMetrics = useGlobalMetrics;
    }

    public boolean isHighConfidenceScores(double sequenceIdentity, double sequenceCoverage) {
        if (this.useGlobalMetrics) {
            return sequenceIdentity >= 0.85;
        }
        return sequenceIdentity >= 0.95 && sequenceCoverage >= 0.75;
    }
}

