/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.alignment.Alignments;
import org.biojava.nbio.alignment.SimpleGapPenalty;
import org.biojava.nbio.alignment.template.GapPenalty;
import org.biojava.nbio.core.alignment.matrices.SimpleSubstitutionMatrix;
import org.biojava.nbio.core.alignment.template.AlignedSequence;
import org.biojava.nbio.core.alignment.template.SequencePair;
import org.biojava.nbio.core.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ChainImpl;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.io.SeqRes2AtomAligner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureSequenceMatcher {
    private static final Logger logger = LoggerFactory.getLogger(StructureSequenceMatcher.class);

    public static Structure getSubstructureMatchingProteinSequence(ProteinSequence sequence, Structure wholeStructure) {
        ResidueNumber[] rns = StructureSequenceMatcher.matchSequenceToStructure(sequence, wholeStructure);
        Structure structure = wholeStructure.clone();
        structure.setChains(new ArrayList<Chain>());
        Chain currentChain = null;
        for (ResidueNumber rn : rns) {
            Group group;
            if (rn == null) continue;
            try {
                group = StructureTools.getGroupByPDBResidueNumber(wholeStructure, rn);
            }
            catch (StructureException e) {
                throw new IllegalArgumentException("Could not find residue " + rn + " in structure", e);
            }
            ChainImpl chain = new ChainImpl();
            chain.setName(group.getChain().getName());
            chain.setId(group.getChain().getId());
            if (currentChain == null || !currentChain.getId().equals(chain.getId())) {
                structure.addChain(chain);
                chain.setEntityInfo(group.getChain().getEntityInfo());
                chain.setStructure(structure);
                chain.setSwissprotId(group.getChain().getSwissprotId());
                chain.setId(group.getChain().getId());
                chain.setName(group.getChain().getName());
                currentChain = chain;
            }
            currentChain.addGroup(group);
        }
        return structure;
    }

    public static ProteinSequence getProteinSequenceForStructure(Structure struct, Map<Integer, Group> groupIndexPosition) {
        if (groupIndexPosition != null) {
            groupIndexPosition.clear();
        }
        StringBuilder seqStr = new StringBuilder();
        for (Chain chain : struct.getChains()) {
            List<Group> groups = chain.getAtomGroups();
            HashMap<Integer, Integer> chainIndexPosition = new HashMap<Integer, Integer>();
            int prevLen = seqStr.length();
            String chainSeq = SeqRes2AtomAligner.getFullAtomSequence(groups, chainIndexPosition, false);
            seqStr.append(chainSeq);
            for (Integer seqIndex : chainIndexPosition.keySet()) {
                Integer groupIndex = (Integer)chainIndexPosition.get(seqIndex);
                groupIndexPosition.put(prevLen + seqIndex, groups.get(groupIndex));
            }
        }
        ProteinSequence s = null;
        try {
            s = new ProteinSequence(seqStr.toString());
        }
        catch (CompoundNotFoundException e) {
            logger.error("Could not create protein sequence, unknown compounds in string: {}", (Object)e.getMessage());
        }
        return s;
    }

    public static ResidueNumber[] matchSequenceToStructure(ProteinSequence seq, Structure struct) {
        HashMap<Integer, Group> atomIndexPosition = new HashMap<Integer, Group>();
        ProteinSequence structSeq = StructureSequenceMatcher.getProteinSequenceForStructure(struct, atomIndexPosition);
        SimpleSubstitutionMatrix matrix = new SimpleSubstitutionMatrix((CompoundSet)AminoAcidCompoundSet.getAminoAcidCompoundSet(), 1, -1);
        matrix = new SimpleSubstitutionMatrix((CompoundSet)AminoAcidCompoundSet.getAminoAcidCompoundSet(), (Reader)new InputStreamReader(SimpleSubstitutionMatrix.class.getResourceAsStream("/matrices/blosum100.txt")), "blosum100");
        SequencePair pair = Alignments.getPairwiseAlignment((Sequence)seq, (Sequence)structSeq, (Alignments.PairwiseSequenceAlignerType)Alignments.PairwiseSequenceAlignerType.GLOBAL, (GapPenalty)new SimpleGapPenalty(), (SubstitutionMatrix)matrix);
        AlignedSequence alignedSeq = pair.getQuery();
        AlignedSequence alignedStruct = pair.getTarget();
        assert (alignedSeq.getLength() == alignedStruct.getLength());
        ResidueNumber[] ca = new ResidueNumber[seq.getLength()];
        for (int pos = alignedSeq.getStart().getPosition().intValue(); pos <= alignedSeq.getEnd().getPosition(); ++pos) {
            if (alignedSeq.isGap(pos)) {
                int structIndex = alignedStruct.getSequenceIndexAt(pos) - 1;
                assert (structIndex > 0);
                Group g = (Group)atomIndexPosition.get(structIndex);
                logger.warn("Chain {} residue {} in the Structure {} has no corresponding amino acid in the sequence.", new Object[]{g.getChainId(), g.getResidueNumber().toString(), g.getChain().getStructure().getPDBCode()});
                continue;
            }
            if (alignedStruct.isGap(pos)) continue;
            int seqIndex = alignedSeq.getSequenceIndexAt(pos) - 1;
            int structIndex = alignedStruct.getSequenceIndexAt(pos) - 1;
            Group g = (Group)atomIndexPosition.get(structIndex);
            assert (0 <= seqIndex && seqIndex < ca.length);
            ca[seqIndex] = g.getResidueNumber();
        }
        return ca;
    }

    public static ProteinSequence removeGaps(ProteinSequence gapped) {
        int i;
        String[] gapStrings = new String[]{"-", "."};
        StringBuilder seq = new StringBuilder();
        CompoundSet aaSet = gapped.getCompoundSet();
        AminoAcidCompound[] gaps = new AminoAcidCompound[gapStrings.length];
        for (i = 0; i < gapStrings.length; ++i) {
            gaps[i] = (AminoAcidCompound)aaSet.getCompoundForString(gapStrings[i]);
        }
        for (i = 1; i <= gapped.getLength(); ++i) {
            AminoAcidCompound aa = (AminoAcidCompound)gapped.getCompoundAt(i);
            boolean isGap = false;
            for (AminoAcidCompound gap : gaps) {
                if (!aa.equals((Object)gap)) continue;
                isGap = true;
                break;
            }
            if (isGap) continue;
            seq.append(aa.getShortName());
        }
        ProteinSequence ungapped = null;
        try {
            ungapped = new ProteinSequence(seq.toString());
        }
        catch (CompoundNotFoundException e) {
            logger.error("Could not create ungapped protein sequence, found unknown compounds: {}. This is most likely a bug.", (Object)e.getMessage());
        }
        return ungapped;
    }

    public static <T> T[][] removeGaps(T[][] gapped) {
        if (gapped == null) {
            return null;
        }
        if (gapped.length < 1) {
            return (Object[][])Arrays.copyOf(gapped, gapped.length);
        }
        int nProts = gapped.length;
        int protLen = gapped[0].length;
        for (int i = 0; i < nProts; ++i) {
            if (gapped[i].length == protLen) continue;
            throw new IllegalArgumentException(String.format("Expected a rectangular array, but row 0 has %d elements while row %d has %d.", protLen, i, gapped[i].length));
        }
        boolean[] isGap = new boolean[protLen];
        int gaps = 0;
        block1: for (int j = 0; j < protLen; ++j) {
            for (int i = 0; i < nProts; ++i) {
                if (gapped[i][j] != null) continue;
                isGap[j] = true;
                ++gaps;
                continue block1;
            }
        }
        Object[][] ungapped = (Object[][])Arrays.copyOf(gapped, nProts);
        int ungappedLen = protLen - gaps;
        for (int i = 0; i < nProts; ++i) {
            ungapped[i] = Arrays.copyOf(gapped[i], ungappedLen);
            int k = 0;
            for (int j = 0; j < protLen; ++j) {
                if (isGap[j]) continue;
                assert (gapped[i][j] != null);
                ungapped[i][k] = gapped[i][j];
                ++k;
            }
            assert (k == ungappedLen);
        }
        return ungapped;
    }
}

