/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.mmtf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.mmtf.MmtfStructureReader;
import org.biojava.nbio.structure.io.mmtf.MmtfStructureWriter;
import org.rcsb.mmtf.api.StructureAdapterInterface;
import org.rcsb.mmtf.api.StructureDataInterface;
import org.rcsb.mmtf.decoder.GenericDecoder;
import org.rcsb.mmtf.decoder.ReaderUtils;
import org.rcsb.mmtf.decoder.StructureDataToAdapter;
import org.rcsb.mmtf.encoder.AdapterToStructureData;
import org.rcsb.mmtf.encoder.WriterUtils;

public class MmtfActions {
    public static Structure readFromFile(Path filePath) throws IOException {
        MmtfStructureReader mmtfStructureReader = new MmtfStructureReader();
        new StructureDataToAdapter((StructureDataInterface)new GenericDecoder(ReaderUtils.getDataFromFile((Path)filePath)), (StructureAdapterInterface)mmtfStructureReader);
        return mmtfStructureReader.getStructure();
    }

    public static void writeToFile(Structure structure, Path path) throws IOException {
        AdapterToStructureData writerToEncoder = new AdapterToStructureData();
        new MmtfStructureWriter(structure, (StructureAdapterInterface)writerToEncoder);
        WriterUtils.writeDataToFile((AdapterToStructureData)writerToEncoder, (Path)path);
    }

    public static void writeToOutputStream(Structure structure, OutputStream outputStream) throws IOException {
        AdapterToStructureData writerToEncoder = new AdapterToStructureData();
        new MmtfStructureWriter(structure, (StructureAdapterInterface)writerToEncoder);
        byte[] outputBytes = WriterUtils.getDataAsByteArr((AdapterToStructureData)writerToEncoder);
        outputStream.write(outputBytes, 0, outputBytes.length);
    }

    public static Structure readFromWeb(String pdbId) throws IOException {
        MmtfStructureReader mmtfStructureReader = new MmtfStructureReader();
        new StructureDataToAdapter((StructureDataInterface)new GenericDecoder(ReaderUtils.getDataFromUrl((String)pdbId)), (StructureAdapterInterface)mmtfStructureReader);
        return mmtfStructureReader.getStructure();
    }

    public static Structure readFromInputStream(InputStream inStream) throws IOException {
        MmtfStructureReader mmtfStructureReader = new MmtfStructureReader();
        new StructureDataToAdapter((StructureDataInterface)new GenericDecoder(ReaderUtils.getDataFromInputStream((InputStream)inStream)), (StructureAdapterInterface)mmtfStructureReader);
        return mmtfStructureReader.getStructure();
    }
}

