/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.biojava.nbio.structure.geometry.SuperPositions;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryScores;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetrySubunits;

public class QuatSuperpositionScorer {
    public static QuatSymmetryScores calcScores(QuatSymmetrySubunits subunits, Matrix4d transformation, List<Integer> permutation) {
        QuatSymmetryScores scores = new QuatSymmetryScores();
        double minTm = Double.MAX_VALUE;
        double maxTm = Double.MIN_VALUE;
        double minRmsd = Double.MAX_VALUE;
        double maxRmsd = Double.MIN_VALUE;
        double totalSumTm = 0.0;
        double totalSumDsq = 0.0;
        double totalLength = 0.0;
        Point3d t = new Point3d();
        List<Point3d[]> traces = subunits.getTraces();
        for (int i = 0; i < traces.size(); ++i) {
            if (permutation.get(i) == -1) continue;
            Point3d[] orig = traces.get(i);
            totalLength += (double)orig.length;
            Point3d[] perm = traces.get(permutation.get(i));
            int tmLen = Math.max(orig.length, 17);
            double d0 = 1.24 * Math.cbrt((double)tmLen - 15.0) - 1.8;
            double d0Sq = d0 * d0;
            double sumTm = 0.0;
            double sumDsq = 0.0;
            for (int j = 0; j < orig.length; ++j) {
                t.set((Tuple3d)perm[j]);
                transformation.transform(t);
                double dSq = orig[j].distanceSquared(t);
                sumTm += 1.0 / (1.0 + dSq / d0Sq);
                sumDsq += dSq;
            }
            double sTm = sumTm / (double)tmLen;
            minTm = Math.min(minTm, sTm);
            maxTm = Math.max(maxTm, sTm);
            double sRmsd = Math.sqrt(sumDsq / (double)orig.length);
            minRmsd = Math.min(minRmsd, sRmsd);
            maxRmsd = Math.max(maxRmsd, sRmsd);
            totalSumTm += sumTm;
            totalSumDsq += sumDsq;
        }
        scores.setMinRmsd(minRmsd);
        scores.setMaxRmsd(maxRmsd);
        scores.setMinTm(minTm);
        scores.setMaxTm(maxTm);
        scores.setTm(totalSumTm / totalLength);
        scores.setRmsd(Math.sqrt(totalSumDsq / totalLength));
        QuatSuperpositionScorer.calcIntrasubunitScores(subunits, transformation, permutation, scores);
        return scores;
    }

    private static void calcIntrasubunitScores(QuatSymmetrySubunits subunits, Matrix4d transformation, List<Integer> permutation, QuatSymmetryScores scores) {
        double totalSumTm = 0.0;
        double totalSumDsq = 0.0;
        double totalLength = 0.0;
        List<Point3d[]> traces = subunits.getTraces();
        for (int i = 0; i < traces.size(); ++i) {
            int j;
            if (permutation.get(i) == -1) continue;
            Point3d[] orig = traces.get(i);
            totalLength += (double)orig.length;
            Point3d[] perm = traces.get(permutation.get(i));
            int tmLen = Math.max(orig.length, 17);
            double d0 = 1.24 * Math.cbrt((double)tmLen - 15.0) - 1.8;
            double d0Sq = d0 * d0;
            double sumTm = 0.0;
            double sumDsq = 0.0;
            Point3d[] trans = new Point3d[orig.length];
            for (j = 0; j < orig.length; ++j) {
                trans[j] = new Point3d(perm[j]);
            }
            SuperPositions.superposeAndTransform(orig, trans);
            for (j = 0; j < orig.length; ++j) {
                double dSq = orig[j].distanceSquared(trans[j]);
                sumTm += 1.0 / (1.0 + dSq / d0Sq);
                sumDsq += dSq;
            }
            totalSumTm += sumTm;
            totalSumDsq += sumDsq;
        }
        scores.setRmsdIntra(Math.sqrt(totalSumDsq / totalLength));
        scores.setTmIntra(totalSumTm / totalLength);
    }
}

