/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.cox;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.biojava.nbio.survival.cox.SurvivalInfo;

public class SurvivalInfoHelper {
    public static void dump(ArrayList<SurvivalInfo> DataT, PrintStream ps, String delimiter) {
        ArrayList<String> variables = DataT.get(0).getDataVariables();
        ps.print("Seq" + delimiter);
        for (String variable : variables) {
            ps.print(variable + delimiter);
        }
        ps.print("TIME" + delimiter + "STATUS" + delimiter + "WEIGHT" + delimiter + "STRATA");
        ps.println();
        for (SurvivalInfo si : DataT) {
            ps.print(si.getOrder() + delimiter);
            for (String variable : variables) {
                Double value = si.getVariable(variable);
                ps.print(value + delimiter);
            }
            ps.print(si.getTime() + delimiter + si.getStatus() + delimiter + si.getWeight() + delimiter + si.getStrata());
            ps.println();
        }
    }

    private static boolean isCategorical(LinkedHashMap<String, Double> values) {
        try {
            for (String value : values.keySet()) {
                Double.parseDouble(value);
            }
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static void categorizeData(ArrayList<SurvivalInfo> DataT) {
        Object map;
        LinkedHashMap<String, LinkedHashMap> valueMap = new LinkedHashMap<String, LinkedHashMap>();
        for (SurvivalInfo si : DataT) {
            for (String key : si.unknownDataType.keySet()) {
                map = (LinkedHashMap)valueMap.get(key);
                if (map == null) {
                    map = new LinkedHashMap();
                    valueMap.put(key, (LinkedHashMap)map);
                }
                ((HashMap)map).put(si.unknownDataType.get(key), null);
            }
        }
        for (String variable : valueMap.keySet()) {
            LinkedHashMap values = (LinkedHashMap)valueMap.get(variable);
            if (SurvivalInfoHelper.isCategorical(values)) {
                int index;
                ArrayList categories = new ArrayList(values.keySet());
                Collections.sort(categories);
                if (categories.size() == 2) {
                    for (String value : values.keySet()) {
                        index = categories.indexOf(value);
                        values.put(value, (double)index + 0.0);
                    }
                    continue;
                }
                for (String value : values.keySet()) {
                    index = categories.indexOf(value);
                    values.put(value, (double)index + 1.0);
                }
                continue;
            }
            for (String value : values.keySet()) {
                Double d = Double.parseDouble(value);
                values.put(value, d);
            }
        }
        for (SurvivalInfo si : DataT) {
            for (String key : si.unknownDataType.keySet()) {
                String value;
                map = (LinkedHashMap)valueMap.get(key);
                value = si.unknownDataType.get(key);
                Double d = (Double)((LinkedHashMap)map).get(value);
                si.data.put(key, d);
            }
        }
        for (SurvivalInfo si : DataT) {
            si.unknownDataType.clear();
        }
    }

    public static ArrayList<String> addInteraction(String variable1, String variable2, ArrayList<SurvivalInfo> survivalInfoList) {
        ArrayList<String> variables = new ArrayList<String>();
        variables.add(variable1);
        variables.add(variable2);
        variables.add(variable1 + ":" + variable2);
        for (SurvivalInfo si : survivalInfoList) {
            Double value1 = si.getVariable(variable1);
            Double value2 = si.getVariable(variable2);
            Double value3 = value1 * value2;
            si.addContinuousVariable(variable1 + ":" + variable2, value3);
        }
        return variables;
    }

    public static void groupByRange(double[] range, String variable, String groupName, ArrayList<SurvivalInfo> survivalInfoList) throws Exception {
        String label;
        int rangeIndex;
        Double value;
        ArrayList<String> labels = new ArrayList<String>();
        for (int i = 0; i < range.length; ++i) {
            String label2 = "";
            if (i == 0) {
                label2 = "[<=" + range[i] + "]";
            } else if (i == range.length - 1) {
                label2 = "[" + (range[i - 1] + 1.0) + "-" + range[i] + "]";
                labels.add(label2);
                label2 = "[>" + range[i] + "]";
            } else {
                label2 = "[" + (range[i - 1] + 1.0) + "-" + range[i] + "]";
            }
            labels.add(label2);
        }
        ArrayList<String> validLabels = new ArrayList<String>();
        for (SurvivalInfo si : survivalInfoList) {
            value = si.getContinuousVariable(variable);
            if (value == null) {
                throw new Exception("Variable " + variable + " not found in " + si.toString());
            }
            rangeIndex = SurvivalInfoHelper.getRangeIndex(range, value);
            label = (String)labels.get(rangeIndex);
            if (validLabels.contains(groupName + "_" + label)) continue;
            validLabels.add(groupName + "_" + label);
        }
        Collections.sort(validLabels);
        System.out.println("Valid Lables:" + validLabels);
        for (SurvivalInfo si : survivalInfoList) {
            value = si.getContinuousVariable(variable);
            if (value == null) {
                throw new Exception("Variable " + variable + " not found in " + si.toString());
            }
            rangeIndex = SurvivalInfoHelper.getRangeIndex(range, value);
            label = (String)labels.get(rangeIndex);
            String inLable = groupName + "_" + label;
            for (String gl : validLabels) {
                if (gl.equals(inLable)) {
                    si.addContinuousVariable(gl, 1.0);
                    continue;
                }
                si.addContinuousVariable(gl, 0.0);
            }
        }
    }

    public static ArrayList<String> getGroupCategories(String groupName, ArrayList<SurvivalInfo> survivalInfoList) {
        return survivalInfoList.get(0).getGroupCategories(groupName);
    }

    private static int getRangeIndex(double[] range, double value) throws Exception {
        for (int i = 0; i < range.length; ++i) {
            if (i == 0 && value <= range[i]) {
                return i;
            }
            if (!(value <= range[i])) continue;
            return i;
        }
        if (value > range[range.length - 1]) {
            return range.length;
        }
        throw new Exception("Value " + value + " not found in range ");
    }
}

