/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.kaplanmeier.figure;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import javax.swing.JPanel;
import org.biojava.nbio.survival.cox.StrataInfo;
import org.biojava.nbio.survival.cox.SurvFitInfo;
import org.biojava.nbio.survival.kaplanmeier.figure.KMFigureInfo;
import org.biojava.nbio.survival.kaplanmeier.figure.KaplanMeierFigure;

public class NumbersAtRiskPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    KaplanMeierFigure kmf = null;
    Double timePercentage = 0.2;

    public NumbersAtRiskPanel() {
        this.setPreferredSize(new Dimension(400, 100));
        this.setSize(400, 100);
    }

    public void setKaplanMeierFigure(KaplanMeierFigure kmf) {
        this.kmf = kmf;
        int numRows = kmf.getSurvivalFitInfo().getStrataInfoHashMap().size();
        int height = (numRows + 1) * this.getFontMetrics(this.getFont()).getHeight();
        int width = kmf.getWidth();
        this.setPreferredSize(new Dimension(width, height));
        this.setSize(width, height);
    }

    private void paintTable(Graphics g) {
        int fontHeight;
        if (this.kmf == null) {
            return;
        }
        KMFigureInfo kmfi = this.kmf.getKMFigureInfo();
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(kmfi.kmStroke);
        SurvFitInfo sfi = this.kmf.getSurvivalFitInfo();
        LinkedHashMap<Object, Object> sfiHashMap = new LinkedHashMap();
        sfiHashMap = sfi.isWeighted() ? sfi.getUnweightedStrataInfoHashMap() : sfi.getStrataInfoHashMap();
        if (sfiHashMap.size() == 0) {
            return;
        }
        int row = 0;
        int left = this.kmf.getLeft();
        Font f = g2.getFont();
        Font nf = new Font(f.getName(), 1, f.getSize());
        g2.setFont(nf);
        FontMetrics fm = this.getFontMetrics(nf);
        int index = 0;
        int increment = fontHeight = this.getFontMetrics(this.getFont()).getHeight();
        ArrayList<Double> xaxisTimeValues = this.kmf.getxAxisTimeValues();
        ArrayList<Integer> xAxisTimeCoordinates = this.kmf.getxAxisTimeCoordinates();
        ArrayList<Object> labels = new ArrayList<Object>(sfiHashMap.keySet());
        Collections.sort(labels);
        for (String string : labels) {
            g2.setColor(kmfi.getColor(index));
            ++index;
            g2.drawLine(15, (row += increment) - fontHeight / 2, left - 5, row - fontHeight / 2);
            g2.setColor(Color.BLACK);
            StrataInfo si = (StrataInfo)sfiHashMap.get(string);
            if (this.kmf.title.toString().equals("[APOBEC1 Transhera Observation Arm]")) {
                // empty if block
            }
            for (int i = 0; i < xaxisTimeValues.size(); ++i) {
                Double time = xaxisTimeValues.get(i);
                int xvalue = xAxisTimeCoordinates.get(i);
                Double value = si.getNearestAtRisk(time);
                String nrisk = "";
                nrisk = value == null ? "" : value.intValue() + "";
                if (time == 0.0) {
                    g2.drawString(nrisk, xvalue, row);
                    continue;
                }
                int w = fm.stringWidth(nrisk);
                g2.drawString(nrisk, xvalue - w / 2, row);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintTable(g);
    }

    public static void main(String[] args) {
    }
}

