/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.cox;

import java.util.ArrayList;
import org.biojava.nbio.survival.cox.CoxMethod;
import org.biojava.nbio.survival.cox.SurvivalInfo;

public class CoxMart {
    public static double[] process(CoxMethod method, ArrayList<SurvivalInfo> survivalInfoList, boolean useStrata) {
        int j;
        int i;
        int n = survivalInfoList.size();
        double denom = 0.0;
        double e_denom = 0.0;
        double[] time = new double[n];
        double[] status = new double[n];
        double[] strata = new double[n];
        double[] wt = new double[n];
        double[] score = new double[n];
        double[] expect = new double[survivalInfoList.size()];
        for (int p = 0; p < n; ++p) {
            SurvivalInfo si = survivalInfoList.get(p);
            time[p] = si.getTime();
            status[p] = si.getStatus();
            strata[p] = useStrata ? (double)si.getStrata() : 0.0;
            wt[p] = si.getWeight();
            score[p] = si.getScore();
        }
        strata[n - 1] = 1.0;
        for (i = n - 1; i >= 0; --i) {
            if (strata[i] == 1.0) {
                denom = 0.0;
            }
            expect[i] = i == 0 || strata[i - 1] == 1.0 || time[i - 1] != time[i] ? (denom += score[i] * wt[i]) : 0.0;
        }
        double deaths = 0.0;
        double wtsum = 0.0;
        e_denom = 0.0;
        double hazard = 0.0;
        int lastone = 0;
        for (i = 0; i < n; ++i) {
            if (expect[i] != 0.0) {
                denom = expect[i];
            }
            expect[i] = status[i];
            deaths += status[i];
            wtsum += status[i] * wt[i];
            e_denom += score[i] * status[i] * wt[i];
            if (strata[i] == 1.0 || time[i + 1] != time[i]) {
                if (deaths < 2.0 || method == CoxMethod.Breslow) {
                    hazard += wtsum / denom;
                    for (j = lastone; j <= i; ++j) {
                        int n2 = j;
                        expect[n2] = expect[n2] - score[j] * hazard;
                    }
                } else {
                    double temp = hazard;
                    wtsum /= deaths;
                    j = 0;
                    while ((double)j < deaths) {
                        double downwt = (double)j / deaths;
                        hazard += wtsum / (denom - e_denom * downwt);
                        temp += wtsum * (1.0 - downwt) / (denom - e_denom * downwt);
                        ++j;
                    }
                    for (j = lastone; j <= i; ++j) {
                        if (status[j] == 0.0) {
                            expect[j] = -score[j] * hazard;
                            continue;
                        }
                        int n3 = j;
                        expect[n3] = expect[n3] - score[j] * temp;
                    }
                }
                lastone = i + 1;
                deaths = 0.0;
                wtsum = 0.0;
                e_denom = 0.0;
            }
            if (strata[i] != 1.0) continue;
            hazard = 0.0;
        }
        for (j = lastone; j < n; ++j) {
            int n4 = j;
            expect[n4] = expect[n4] - score[j] * hazard;
        }
        return expect;
    }

    public static void main(String[] args) {
    }
}

