/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.cox;

import java.util.ArrayList;
import org.biojava.nbio.survival.cox.CoxInfo;
import org.biojava.nbio.survival.cox.CoxMethod;
import org.biojava.nbio.survival.cox.SurvivalInfo;

public class CoxScore {
    public static double[][] process(CoxMethod method, ArrayList<SurvivalInfo> survivalInfoList, CoxInfo coxInfo, boolean useStrata) {
        int i;
        int v;
        SurvivalInfo si;
        int p;
        int n = survivalInfoList.size();
        ArrayList<String> variables = new ArrayList<String>(coxInfo.getCoefficientsList().keySet());
        int nvar = variables.size();
        double[] time = new double[n];
        double[] status = new double[n];
        double[] strata = new double[n];
        double[] weights = new double[n];
        double[] score = new double[n];
        double[] a = new double[nvar];
        double[] a2 = new double[nvar];
        double denom = 0.0;
        double[][] covar = new double[nvar][n];
        double[][] resid = new double[nvar][n];
        for (p = 0; p < n; ++p) {
            si = survivalInfoList.get(p);
            time[p] = si.getTime();
            status[p] = si.getStatus();
            strata[p] = useStrata ? (double)si.getStrata() : 0.0;
            weights[p] = si.getWeight();
            score[p] = si.getScore();
            for (v = 0; v < variables.size(); ++v) {
                String variable = variables.get(v);
                Double value = si.getVariable(variable);
                covar[v][p] = value;
            }
        }
        double e_denom = 0.0;
        double deaths = 0.0;
        double meanwt = 0.0;
        for (i = 0; i < nvar; ++i) {
            a2[i] = 0.0;
        }
        strata[n - 1] = 1.0;
        for (i = n - 1; i >= 0; --i) {
            double temp2;
            int k;
            double temp;
            double hazard;
            int j;
            if (strata[i] == 1.0) {
                denom = 0.0;
                for (j = 0; j < nvar; ++j) {
                    a[j] = 0.0;
                }
            }
            double risk = score[i] * weights[i];
            denom += risk;
            if (status[i] == 1.0) {
                deaths += 1.0;
                e_denom += risk;
                meanwt += weights[i];
                for (j = 0; j < nvar; ++j) {
                    int n2 = j;
                    a2[n2] = a2[n2] + risk * covar[j][i];
                }
            }
            for (j = 0; j < nvar; ++j) {
                int n3 = j;
                a[n3] = a[n3] + risk * covar[j][i];
                resid[j][i] = 0.0;
            }
            if (!(deaths > 0.0) || i != 0 && strata[i - 1] != 1.0 && time[i] == time[i - 1]) continue;
            if (deaths < 2.0 || method == CoxMethod.Breslow) {
                hazard = meanwt / denom;
                block7: for (j = 0; j < nvar; ++j) {
                    temp = a[j] / denom;
                    for (k = i; k < n; ++k) {
                        temp2 = covar[j][k] - temp;
                        if (time[k] == time[i] && status[k] == 1.0) {
                            double[] dArray = resid[j];
                            int n4 = k;
                            dArray[n4] = dArray[n4] + temp2;
                        }
                        double[] dArray = resid[j];
                        int n5 = k;
                        dArray[n5] = dArray[n5] - temp2 * score[k] * hazard;
                        if (strata[k] == 1.0) continue block7;
                    }
                }
            } else {
                meanwt /= deaths;
                int dd = 0;
                while ((double)dd < deaths) {
                    double downwt = (double)dd / deaths;
                    temp = denom - downwt * e_denom;
                    hazard = meanwt / temp;
                    block10: for (j = 0; j < nvar; ++j) {
                        double mean = (a[j] - downwt * a2[j]) / temp;
                        for (k = i; k < n; ++k) {
                            temp2 = covar[j][k] - mean;
                            if (time[k] == time[i] && status[k] == 1.0) {
                                double[] dArray = resid[j];
                                int n6 = k;
                                dArray[n6] = dArray[n6] + temp2 / deaths;
                                double[] dArray2 = resid[j];
                                int n7 = k;
                                dArray2[n7] = dArray2[n7] - temp2 * score[k] * hazard * (1.0 - downwt);
                            } else {
                                double[] dArray = resid[j];
                                int n8 = k;
                                dArray[n8] = dArray[n8] - temp2 * score[k] * hazard;
                            }
                            if (strata[k] == 1.0) continue block10;
                        }
                    }
                    ++dd;
                }
            }
            e_denom = 0.0;
            deaths = 0.0;
            meanwt = 0.0;
            for (j = 0; j < nvar; ++j) {
                a2[j] = 0.0;
            }
        }
        for (p = 0; p < n; ++p) {
            si = survivalInfoList.get(p);
            for (v = 0; v < variables.size(); ++v) {
                si.setResidualVariable(variables.get(v), resid[v][p]);
            }
        }
        double[][] flipresid = new double[n][nvar];
        for (int s = 0; s < resid.length; ++s) {
            for (int t = 0; t < resid[0].length; ++t) {
                flipresid[t][s] = resid[s][t];
            }
        }
        return flipresid;
    }

    public static void main(String[] args) {
    }
}

