/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.cox;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.biojava.nbio.survival.cox.CoxInfo;
import org.biojava.nbio.survival.cox.CoxScore;
import org.biojava.nbio.survival.cox.matrix.Matrix;

public class ResidualsCoxph {
    public static double[][] process(CoxInfo ci, Type type, boolean useWeighted, ArrayList<String> cluster) throws Exception {
        Type otype = type;
        if (type == Type.dfbeta || type == Type.dfbetas) {
            type = Type.score;
        }
        double[][] rr = null;
        if (type == Type.score) {
            rr = CoxScore.process(ci.method, ci.survivalInfoList, ci, false);
        }
        double[][] vv = null;
        vv = ci.getNaiveVariance() != null ? ci.getNaiveVariance() : ci.getVariance();
        if (otype == Type.dfbeta) {
            rr = Matrix.multiply(rr, vv);
        } else if (otype == Type.dfbetas) {
            double[][] d1 = Matrix.multiply(rr, vv);
            double[][] d2 = Matrix.diag(Matrix.sqrt(Matrix.oneDivide(Matrix.diag(vv))));
            rr = Matrix.multiply(d1, d2);
        }
        if (useWeighted) {
            double[] weighted = ci.getWeighted();
            rr = Matrix.scale(rr, weighted);
        }
        if (cluster != null && cluster.size() > 0) {
            rr = ResidualsCoxph.rowsum(rr, cluster);
        }
        return rr;
    }

    private static double[][] rowsum(double[][] rr, ArrayList<String> sets) throws Exception {
        LinkedHashMap<String, Double> sumMap = new LinkedHashMap<String, Double>();
        if (rr.length != sets.size()) {
            throw new Exception("Cluster value for each sample are not of equal length n=" + rr.length + " cluster length=" + sets.size());
        }
        double[][] sum = null;
        for (int j = 0; j < rr[0].length; ++j) {
            for (int i = 0; i < sets.size(); ++i) {
                String s = sets.get(i);
                Double v = (Double)sumMap.get(s);
                if (v == null) {
                    v = 0.0;
                }
                v = v + rr[i][j];
                sumMap.put(s, v);
            }
            if (sum == null) {
                sum = new double[sumMap.size()][rr[0].length];
            }
            ArrayList index = new ArrayList(sumMap.keySet());
            for (int m = 0; m < index.size(); ++m) {
                String key = ((String)index.get(m)).toString();
                sum[m][j] = (Double)sumMap.get(key);
            }
            sumMap.clear();
        }
        return sum;
    }

    public static void main(String[] args) {
    }

    public static enum Type {
        dfbeta,
        dfbetas,
        score;

    }
}

