/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.cox;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class StrataInfo {
    private ArrayList<Double> time = new ArrayList();
    private ArrayList<Integer> status = new ArrayList();
    private ArrayList<Double> nevent = new ArrayList();
    private ArrayList<Double> ncens = new ArrayList();
    private ArrayList<Double> nrisk = new ArrayList();
    private ArrayList<Double> weight = new ArrayList();
    private ArrayList<Double> surv = new ArrayList();
    private ArrayList<Double> varhaz = new ArrayList();
    private ArrayList<Double> stderr = new ArrayList();
    private ArrayList<Double> stdlow = new ArrayList();
    private ArrayList<Double> upper = new ArrayList();
    private ArrayList<Double> lower = new ArrayList();
    private LinkedHashMap<Double, Integer> ndead = new LinkedHashMap();
    DecimalFormat df = new DecimalFormat("#.######");
    DecimalFormat dfe = new DecimalFormat("0.000000E0");

    public Double getNearestTime(double timePercentage) {
        Double minTime = null;
        Double maxTime = null;
        for (Double t : this.time) {
            if (minTime == null || t < minTime) {
                minTime = t;
            }
            if (maxTime != null && !(t > maxTime)) continue;
            maxTime = t;
        }
        Double timeRange = maxTime - minTime;
        Double targetTime = minTime + timePercentage * timeRange;
        Double previousTime = null;
        for (Double t : this.time) {
            if (previousTime == null || t <= targetTime) {
                previousTime = t;
                continue;
            }
            return previousTime;
        }
        return previousTime;
    }

    public Double getNearestAtRisk(double t) {
        Integer index = 0;
        DecimalFormat newFormat = new DecimalFormat("#.#");
        for (int i = 0; i < this.time.size(); ++i) {
            Double compareTime = this.time.get(i);
            if (!((compareTime = Double.valueOf(newFormat.format(compareTime))) < t)) {
                if (compareTime != t) break;
                index = i;
                break;
            }
            index = i + 1;
        }
        if (index >= this.nrisk.size()) {
            return null;
        }
        return this.nrisk.get(index);
    }

    public String f(Double d) {
        String v = this.df.format(d);
        int l = 10 - v.length();
        for (int i = 0; i < l; ++i) {
            v = v + " ";
        }
        return v;
    }

    public String toString() {
        String o = "";
        o = o + "n=" + this.nevent.size() + "\r\n";
        o = o + "     time      nevent     ncens     nrisk     weight     surv   varhaz    stderr    stdlow    lower    upper\r\n";
        for (int i = 0; i < this.nevent.size(); ++i) {
            o = o + (i + 1) + "    " + this.f(this.time.get(i)) + " " + this.f(this.nevent.get(i)) + " " + this.f(this.ncens.get(i)) + " " + this.f(this.nrisk.get(i)) + " " + this.f(this.weight.get(i)) + " " + this.f(this.surv.get(i)) + " " + this.varhaz.get(i) + "  " + this.stderr.get(i) + "  " + this.stdlow.get(i) + "  " + this.lower.get(i) + "  " + this.upper.get(i) + "\r\n";
        }
        o = o + "\r\n";
        return o;
    }

    public ArrayList<Double> getTime() {
        return this.time;
    }

    public ArrayList<Double> getSurv() {
        return this.surv;
    }

    public ArrayList<Double> getStderr() {
        return this.stderr;
    }

    public ArrayList<Double> getUpper() {
        return this.upper;
    }

    public ArrayList<Double> getLower() {
        return this.lower;
    }

    public ArrayList<Integer> getStatus() {
        return this.status;
    }

    public ArrayList<Double> getNevent() {
        return this.nevent;
    }

    public ArrayList<Double> getNcens() {
        return this.ncens;
    }

    public ArrayList<Double> getNrisk() {
        return this.nrisk;
    }

    public ArrayList<Double> getWeight() {
        return this.weight;
    }

    public LinkedHashMap<Double, Integer> getNdead() {
        return this.ndead;
    }

    public ArrayList<Double> getVarhaz() {
        return this.varhaz;
    }

    public ArrayList<Double> getStdlow() {
        return this.stdlow;
    }

    public void setStdlow(ArrayList<Double> stdlow) {
        this.stdlow = stdlow;
    }
}

