/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.cox;

import java.util.ArrayList;
import java.util.LinkedHashMap;

public class SurvivalInfo
implements Comparable<SurvivalInfo> {
    private String id = "";
    private double time;
    private int status;
    private int order = 0;
    private double offset = 0.0;
    private double weight = 1.0;
    private int strata = 0;
    private double score = 0.0;
    private double linearPredictor = 0.0;
    private double residual = 0.0;
    private String clusterValue = "";
    LinkedHashMap<String, Double> residualVariableMap = new LinkedHashMap();
    LinkedHashMap<String, Double> data = new LinkedHashMap();
    LinkedHashMap<String, String> unknownDataType = new LinkedHashMap();
    LinkedHashMap<String, String> originalMetaData = new LinkedHashMap();

    public SurvivalInfo(double t, int e) {
        this.time = t;
        this.status = e;
    }

    public SurvivalInfo(double t, int e, LinkedHashMap<String, Double> d) {
        this.time = t;
        this.status = e;
        this.data = d;
        for (String key : d.keySet()) {
            Double value = d.get(key);
            this.originalMetaData.put(key, value + "");
        }
    }

    public SurvivalInfo(double t, int e, String variable, double d) {
        this.time = t;
        this.status = e;
        this.data.put(variable, d);
        this.originalMetaData.put(variable, d + "");
    }

    public void setResidualVariable(String variable, Double value) {
        this.residualVariableMap.put(variable, value);
    }

    public Double getResidualVariable(String variable) {
        return this.residualVariableMap.get(variable);
    }

    public String getUnknownDataTypeVariable(String variable) {
        return this.unknownDataType.get(variable);
    }

    public String getOriginalMetaData(String variable) {
        return this.originalMetaData.get(variable);
    }

    public void addUnknownDataTypeVariable(String variable, String value) {
        this.originalMetaData.put(variable, value);
        this.unknownDataType.put(variable, value);
    }

    public void updateContinousVariable(String variable, Double value) {
        this.data.put(variable, value);
    }

    public void addContinuousVariable(String variable, Double value) {
        this.originalMetaData.put(variable, value + "");
        this.data.put(variable, value);
    }

    public Double getContinuousVariable(String variable) {
        return this.data.get(variable);
    }

    public ArrayList<String> getGroupCategories(String groupName) {
        ArrayList<String> groupNameList = new ArrayList<String>();
        for (String key : this.data.keySet()) {
            if (!key.startsWith(groupName + "_")) continue;
            groupNameList.add(key);
        }
        return groupNameList;
    }

    public ArrayList<String> getDataVariables() {
        ArrayList<String> v = new ArrayList<String>();
        v.addAll(this.data.keySet());
        v.addAll(this.unknownDataType.keySet());
        return v;
    }

    public int getNumberVariables() {
        return this.data.size();
    }

    public Double getVariable(String variable) {
        Double value = this.data.get(variable);
        return value;
    }

    public String toString() {
        return "t=" + this.time + " e=" + this.status + " o=" + this.order;
    }

    @Override
    public int compareTo(SurvivalInfo o) {
        if (this.time < o.time) {
            return -1;
        }
        if (this.time > o.time) {
            return 1;
        }
        if (this.status == o.status) {
            return 0;
        }
        if (this.status == 1) {
            return -1;
        }
        return 1;
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double offset) {
        this.offset = offset;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public int getStrata() {
        return this.strata;
    }

    public void setStrata(int strata) {
        this.strata = strata;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public double getLinearPredictor() {
        return this.linearPredictor;
    }

    public void setLinearPredictor(double linearPredictor) {
        this.linearPredictor = linearPredictor;
    }

    public double getResidual() {
        return this.residual;
    }

    public void setResidual(double residual) {
        this.residual = residual;
    }

    public String getClusterValue() {
        return this.clusterValue;
    }

    public void setClusterValue(String clusterValue) {
        this.clusterValue = clusterValue;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double time) {
        this.time = time;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}

