/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.cox;

import org.biojava.nbio.survival.cox.WaldTestInfo;
import org.biojava.nbio.survival.cox.stats.Cholesky2;
import org.biojava.nbio.survival.cox.stats.Chsolve2;

public class WaldTest {
    public static WaldTestInfo process(double[][] var, double[] b, double toler_chol) {
        double[][] b_ = new double[1][b.length];
        for (int i = 0; i < b.length; ++i) {
            b_[0][i] = b[i];
        }
        return WaldTest.process(var, b_, toler_chol);
    }

    public static WaldTestInfo process(double[][] var, double[][] b, double toler_chol) {
        int i = 0;
        int ntest = 1;
        int nvar = b[0].length;
        double sum = 0.0;
        double[][] solve = new double[ntest][nvar];
        double[] bsum = new double[ntest];
        Cholesky2.process(var, nvar, toler_chol);
        int df = 0;
        for (i = 0; i < nvar; ++i) {
            if (!(var[i][i] > 0.0)) continue;
            ++df;
        }
        for (i = 0; i < ntest; ++i) {
            int j;
            for (j = 0; j < nvar; ++j) {
                solve[i][j] = b[i][j];
            }
            Chsolve2.process(var, nvar, solve, i);
            sum = 0.0;
            for (j = 0; j < nvar; ++j) {
                sum += b[i][j] * solve[i][j];
            }
            bsum[i] = sum;
        }
        WaldTestInfo waldTestInfo = new WaldTestInfo();
        waldTestInfo.setDf(df);
        waldTestInfo.solve = solve;
        waldTestInfo.bsum = bsum;
        return waldTestInfo;
    }
}

