/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.cox.matrix;

import org.biojava.nbio.survival.cox.matrix.StdArrayIO;

public class Matrix {
    public static double[][] sqrt(double[][] A) {
        double[][] d = new double[A.length][A[0].length];
        for (int i = 0; i < d.length; ++i) {
            for (int j = 0; j < d[0].length; ++j) {
                d[i][j] = Math.sqrt(A[i][j]);
            }
        }
        return d;
    }

    public static double[] sqrt(double[] A) {
        double[] d = new double[A.length];
        for (int i = 0; i < d.length; ++i) {
            d[i] = Math.sqrt(A[i]);
        }
        return d;
    }

    public static double[][] oneDivide(double[][] A) {
        double[][] d = new double[A.length][A[0].length];
        for (int i = 0; i < d.length; ++i) {
            for (int j = 0; j < d[0].length; ++j) {
                d[i][j] = 1.0 / A[i][j];
            }
        }
        return d;
    }

    public static double[] oneDivide(double[] A) {
        double[] d = new double[A.length];
        for (int i = 0; i < d.length; ++i) {
            d[i] = 1.0 / A[i];
        }
        return d;
    }

    public static double[] diag(double[][] A) {
        double[] d = new double[A.length];
        for (int i = 0; i < d.length; ++i) {
            d[i] = A[i][i];
        }
        return d;
    }

    public static double[][] diag(double[] A) {
        double[][] d = new double[A.length][A.length];
        for (int i = 0; i < d.length; ++i) {
            d[i][i] = A[i];
        }
        return d;
    }

    public static double[][] abs(double[][] A) {
        int m = A.length;
        int n = A[0].length;
        double[][] C = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                C[i][j] = Math.abs(A[i][j]);
            }
        }
        return C;
    }

    public static double[] abs(double[] A) {
        int m = A.length;
        double[] C = new double[m];
        for (int i = 0; i < m; ++i) {
            C[i] = Math.abs(A[i]);
        }
        return C;
    }

    public static double[][] random(int m, int n) {
        double[][] C = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                C[i][j] = Math.random();
            }
        }
        return C;
    }

    public static double[][] identity(int n) {
        double[][] I = new double[n][n];
        for (int i = 0; i < n; ++i) {
            I[i][i] = 1.0;
        }
        return I;
    }

    public static double dot(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new RuntimeException("Illegal vector dimensions.");
        }
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += x[i] * y[i];
        }
        return sum;
    }

    public static double[][] transpose(double[][] A) {
        int m = A.length;
        int n = A[0].length;
        double[][] C = new double[n][m];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                C[j][i] = A[i][j];
            }
        }
        return C;
    }

    public static double[][] add(double[][] A, double[][] B) {
        int m = A.length;
        int n = A[0].length;
        double[][] C = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                C[i][j] = A[i][j] + B[i][j];
            }
        }
        return C;
    }

    public static double[][] subtract(double[][] A, double[][] B) {
        int m = A.length;
        int n = A[0].length;
        double[][] C = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                C[i][j] = A[i][j] - B[i][j];
            }
        }
        return C;
    }

    public static double[][] multiply(double[][] A, double[][] B) {
        int mA = A.length;
        int nA = A[0].length;
        int mB = B.length;
        int nB = B[0].length;
        if (nA != mB) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        double[][] C = new double[mA][nB];
        for (int i = 0; i < mA; ++i) {
            for (int j = 0; j < nB; ++j) {
                for (int k = 0; k < nA; ++k) {
                    double[] dArray = C[i];
                    int n = j;
                    dArray[n] = dArray[n] + A[i][k] * B[k][j];
                }
            }
        }
        return C;
    }

    public static double[] multiply(double[][] A, double[] x) {
        int m = A.length;
        int n = A[0].length;
        if (x.length != n) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        double[] y = new double[m];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                int n2 = i;
                y[n2] = y[n2] + A[i][j] * x[j];
            }
        }
        return y;
    }

    public static double[][] scale(double[][] A, double[] x) {
        int m = A.length;
        int n = A[0].length;
        if (x.length != A.length) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        double[][] y = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                y[i][j] = A[i][j] * x[i];
            }
        }
        return y;
    }

    public static double[][] scale(double[][] A, double x) {
        int m = A.length;
        int n = A[0].length;
        double[][] y = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                y[i][j] = A[i][j] * x;
            }
        }
        return y;
    }

    public static double[] multiply(double[] x, double[][] A) {
        int m = A.length;
        int n = A[0].length;
        if (x.length != m) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        double[] y = new double[n];
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                int n2 = j;
                y[n2] = y[n2] + A[i][j] * x[i];
            }
        }
        return y;
    }

    public static void main(String[] args) {
        System.out.println("D");
        System.out.println("--------------------");
        double[][] d = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {9.0, 1.0, 3.0}};
        StdArrayIO.print(d);
        System.out.println();
        System.out.println("I");
        System.out.println("--------------------");
        double[][] c = Matrix.identity(5);
        StdArrayIO.print(c);
        System.out.println();
        System.out.println("A");
        System.out.println("--------------------");
        double[][] a = Matrix.random(5, 5);
        StdArrayIO.print(a);
        System.out.println();
        System.out.println("A^T");
        System.out.println("--------------------");
        double[][] b = Matrix.transpose(a);
        StdArrayIO.print(b);
        System.out.println();
        System.out.println("A + A^T");
        System.out.println("--------------------");
        double[][] e = Matrix.add(a, b);
        StdArrayIO.print(e);
        System.out.println();
        System.out.println("A * A^T");
        System.out.println("--------------------");
        double[][] f = Matrix.multiply(a, b);
        StdArrayIO.print(f);
        System.out.println();
    }
}

