/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.survival.kaplanmeier.figure;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;

public class KMFigureInfo {
    public int titleHeight = 40;
    public int padding = 20;
    public Integer width = 600;
    public Integer height = 400;
    public double timeScale = 1.0;
    public double yaxisPercentIncrement = 0.2;
    public double xaxisPercentIncrement = 0.25;
    public double legendUpperPercentX = 0.95;
    public double legendUpperPercentY = 0.95;
    public double figureLineInfoLowerPercentX = 0.01;
    public double figureLineInfoLowerPercentY = 0.01;
    public BasicStroke axisStroke = new BasicStroke(2.0f);
    public BasicStroke kmStroke = new BasicStroke(3.0f);
    public Color[] legendColor = new Color[]{Color.RED, Color.BLUE, Color.GREEN, Color.CYAN, Color.ORANGE, Color.YELLOW, Color.MAGENTA, Color.PINK};
    public ArrayList<Double> xAxisLabels = new ArrayList();
    public String xAxisLegend = "";
    public String yAxisLegend = "";

    public Color getColor(int index) {
        return this.legendColor[index];
    }

    public void init(String propertyFileName) throws Exception {
        Properties properties = new Properties();
        properties.load(new FileInputStream(propertyFileName));
        if (properties.containsKey("legendUpperPercentX")) {
            this.legendUpperPercentX = Double.parseDouble(properties.getProperty("legendUpperPercentX"));
        }
        if (properties.containsKey("legendUpperPercentY")) {
            this.legendUpperPercentY = Double.parseDouble(properties.getProperty("legendUpperPercentY"));
        }
        if (properties.containsKey("xAxisLabels")) {
            String[] data;
            String values = properties.getProperty("xAxisLabels").trim();
            if (values.startsWith("[") || values.startsWith("(") || values.startsWith("{")) {
                values = values.substring(1, values.length()).trim();
            }
            if (values.endsWith("]") || values.endsWith(")") || values.endsWith("}")) {
                values = values.substring(0, values.length() - 1).trim();
            }
            this.xAxisLabels.clear();
            for (String d : data = values.split(",")) {
                try {
                    Double v = Double.parseDouble(d.trim());
                    this.xAxisLabels.add(v);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (properties.containsKey("xAxisLegend")) {
            this.xAxisLegend = properties.getProperty("xAxisLegend");
        }
        if (properties.containsKey("yAxisLegend")) {
            this.yAxisLegend = properties.getProperty("yAxisLegend");
        }
    }
}

